/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.jfxcentral.data.model;

import com.dlsc.jfxcentral.data.model.Blog;
import com.dlsc.jfxcentral.data.model.ModelObject;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class Post
extends ModelObject {
    private final Blog blog;
    private final SyndFeed syndFeed;
    private final SyndEntry syndEntry;

    public Post(Blog blog, SyndFeed syndFeed, SyndEntry syndEntry) {
        this.blog = blog;
        this.syndFeed = syndFeed;
        this.syndEntry = syndEntry;
    }

    @Override
    public boolean matches(String searchPattern) {
        if (super.matches(searchPattern)) {
            return true;
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)this.syndEntry.getTitle(), (CharSequence[])new CharSequence[]{searchPattern})) {
            return true;
        }
        return StringUtils.containsAnyIgnoreCase((CharSequence)this.syndEntry.getAuthor(), (CharSequence[])new CharSequence[]{searchPattern});
    }

    public Blog getBlog() {
        return this.blog;
    }

    public SyndFeed getSyndFeed() {
        return this.syndFeed;
    }

    public SyndEntry getSyndEntry() {
        return this.syndEntry;
    }

    public LocalDate getDate() {
        Date date = this.syndEntry.getUpdatedDate();
        if (date == null) {
            date = this.syndEntry.getPublishedDate();
        }
        if (date != null) {
            return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        return LocalDate.now();
    }
}

