/*
 * Decompiled with CFR 0.152.
 */
package com.dmurph.tracking;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.AnalyticsRequestData;
import com.dmurph.tracking.GoogleAnalyticsURLBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Random;

public class GoogleAnalyticsV4_7_2
implements GoogleAnalyticsURLBuilder {
    public static final String URL_PREFIX = "http://www.google-analytics.com/__utm.gif";
    private AnalyticsConfigData config;
    private Random random = new Random((long)(Math.random() * 8.3287332738383E13));
    private int cookie1;
    private int cookie2;

    public GoogleAnalyticsV4_7_2(AnalyticsConfigData argConfig) {
        this.config = argConfig;
        this.resetSession();
    }

    public String getGoogleAnalyticsVersion() {
        return "4.7.2";
    }

    public String buildURL(AnalyticsRequestData argData) {
        String encoded;
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX);
        long now = System.currentTimeMillis();
        sb.append("?utmwv=" + this.getGoogleAnalyticsVersion());
        sb.append("&utmn=" + this.random.nextInt());
        if (argData.getHostName() != null) {
            try {
                encoded = URLEncoder.encode(argData.getHostName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            sb.append("&utmhn=" + encoded);
        }
        if (argData.getEventAction() != null && argData.getEventCategory() != null) {
            sb.append("&utmt=event");
            sb.append("&utme=5(" + argData.getEventCategory() + "*" + argData.getEventAction());
            if (argData.getEventLabel() != null) {
                sb.append("*" + argData.getEventLabel());
            }
            sb.append(")");
            if (argData.getEventValue() != null) {
                sb.append("(" + argData.getEventValue() + ")");
            }
        } else if (argData.getEventAction() != null || argData.getEventCategory() != null) {
            throw new IllegalArgumentException("Event tracking must have both a category and an action");
        }
        if (this.config.getEncoding() != null) {
            sb.append("&utmcs=" + this.config.getEncoding());
        } else {
            sb.append("&utmcs=-");
        }
        if (this.config.getScreenResolution() != null) {
            sb.append("&utmsr=" + this.config.getScreenResolution());
        }
        if (this.config.getColorDepth() != null) {
            sb.append("&utmsc=" + this.config.getColorDepth());
        }
        if (this.config.getUserLanguage() != null) {
            sb.append("&utmul=" + this.config.getUserLanguage());
        }
        sb.append("&utmje=1");
        if (this.config.getFlashVersion() != null) {
            try {
                encoded = URLEncoder.encode(this.config.getFlashVersion(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            sb.append("&utmfl=" + encoded);
        }
        if (argData.getPageTitle() != null) {
            try {
                encoded = URLEncoder.encode(argData.getPageTitle(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            sb.append("&utmdt=" + encoded);
        }
        sb.append("&utmhid=" + this.random.nextInt());
        if (argData.getReferrer() != null) {
            sb.append("&utmr=" + argData.getReferrer());
        } else {
            sb.append("&utmr=0");
        }
        if (argData.getPageURL() != null) {
            encoded = null;
            try {
                encoded = URLEncoder.encode(argData.getPageURL(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            sb.append("&utmp=" + encoded);
        }
        sb.append("&utmac=" + this.config.getTrackingCode());
        sb.append("&utmcc=__utma%3D" + this.cookie1 + "." + this.cookie2 + "." + now + "." + now + "." + now + "." + "13%3B%2B__utmz%3D" + this.cookie1 + "." + now + ".1.1.utmcsr%3D(direct)%7Cutmccn%D(direct)%7utmcmd%3D(none)%3B&gaq=1");
        return sb.toString();
    }

    public void resetSession() {
        this.cookie1 = this.random.nextInt();
        this.cookie2 = this.random.nextInt();
    }
}

