/*
 * Decompiled with CFR 0.152.
 */
package com.dmurph.tracking;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.AnalyticsRequestData;
import com.dmurph.tracking.GoogleAnalyticsURLBuilder;
import com.dmurph.tracking.GoogleAnalyticsV4_7_2;
import java.net.HttpURLConnection;
import java.net.URL;

public class JGoogleAnalyticsTracker {
    private static JGoogleAnalyticsTracker tracker = null;
    public static boolean DEBUG_PRINT = false;
    private GoogleAnalyticsVersion gaVersion = GoogleAnalyticsVersion.V_4_7_2;
    private GoogleAnalyticsURLBuilder builder = null;
    private AnalyticsConfigData configData = null;
    private boolean enabled = false;
    private boolean asynchronous = true;
    private final ThreadGroup asyncThreadGroup = new ThreadGroup("Async Google Analytics Threads");

    private JGoogleAnalyticsTracker() {
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void initialize(AnalyticsConfigData argConfigData, GoogleAnalyticsVersion argVersion) {
        this.gaVersion = argVersion;
        this.configData = argConfigData;
        this.createBuilder();
        this.enabled = true;
    }

    public void setEnabled(boolean argEnabled) {
        this.enabled = argEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void trackPageView(String argPageURL, String argPageTitle, String argHostName) {
        this.trackPageView(argPageURL, argPageTitle, argHostName, "http://www.dmurph.com");
    }

    public void trackPageView(String argPageURL, String argPageTitle, String argHostName, String argReferrerURL) {
        if (this.builder == null) {
            throw new RuntimeException("Class was not initialized");
        }
        if (argPageURL == null) {
            throw new IllegalArgumentException("Page URL cannot be null, Google will not track the data.");
        }
        AnalyticsRequestData data = new AnalyticsRequestData();
        data.setHostName(argHostName);
        data.setPageTitle(argPageTitle);
        data.setPageURL(argPageURL);
        data.setReferrer(argReferrerURL);
        this.makeCustomRequest(data);
    }

    public void trackEvent(String argCategory, String argAction) {
        this.trackEvent(argCategory, argAction, null, null);
    }

    public void trackEvent(String argCategory, String argAction, String argLabel) {
        this.trackEvent(argCategory, argAction, argLabel, null);
    }

    public void trackEvent(String argCategory, String argAction, String argLabel, String argValue) {
        if (this.builder == null) {
            throw new RuntimeException("Class was not initialized");
        }
        AnalyticsRequestData data = new AnalyticsRequestData();
        data.setEventCategory(argCategory);
        data.setEventAction(argAction);
        data.setEventLabel(argLabel);
        data.setEventValue(argValue);
        this.makeCustomRequest(data);
    }

    public void makeCustomRequest(AnalyticsRequestData argData) {
        if (argData == null) {
            throw new NullPointerException("Data cannot be null");
        }
        String url = this.builder.buildURL(argData);
        this.makeRequest(url);
    }

    private synchronized void makeRequest(final String argURL) {
        if (!this.enabled) {
            if (DEBUG_PRINT) {
                System.out.println("Ignoring tracking request, enabled is true");
            }
            return;
        }
        if (this.asynchronous) {
            new Thread(this.asyncThreadGroup, "AnalyticThread-" + this.asyncThreadGroup.activeCount()){

                public void run() {
                    JGoogleAnalyticsTracker.this.dispatchRequest(argURL);
                }
            }.start();
        } else {
            this.dispatchRequest(argURL);
        }
    }

    private void dispatchRequest(String argURL) {
        try {
            URL url = new URL(argURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                System.err.println("JGoogleAnalytics: Error requesting url '" + argURL + "', received response code " + responseCode);
            } else if (DEBUG_PRINT) {
                System.out.println("JGoogleAnalytics: Tracking success for url '" + argURL + "'");
            }
        }
        catch (Exception e) {
            System.err.println("Error making tracking request");
            e.printStackTrace();
        }
    }

    private void createBuilder() {
        switch (this.gaVersion) {
            case V_4_7_2: {
                this.builder = new GoogleAnalyticsV4_7_2(this.configData);
            }
        }
    }

    public static synchronized JGoogleAnalyticsTracker getInstance() {
        if (tracker == null) {
            tracker = new JGoogleAnalyticsTracker();
        }
        return tracker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GoogleAnalyticsVersion {
        V_4_7_2;

    }
}

