/*
 * Decompiled with CFR 0.152.
 */
package com.dmurph.tracking;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

public class AnalyticsConfigData {
    private final String trackingCode;
    private String encoding = "UTF-8";
    private String screenResolution = null;
    private String colorDepth = null;
    private String userLanguage = null;
    private String flashVersion = null;

    public AnalyticsConfigData(String argTrackingCode) {
        if (argTrackingCode == null) {
            throw new RuntimeException("Tracking code cannot be null");
        }
        this.trackingCode = argTrackingCode;
        this.populateFromSystem();
    }

    public void populateFromSystem() {
        int i;
        this.encoding = System.getProperty("file.encoding");
        this.userLanguage = System.getProperty("user.language") + "-" + System.getProperty("user.region");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int screenHeight = 0;
        int screenWidth = 0;
        for (i = 0; i < gs.length; ++i) {
            DisplayMode dm = gs[i].getDisplayMode();
            screenWidth += dm.getWidth();
            screenHeight += dm.getHeight();
        }
        if (screenHeight != 0 && screenWidth != 0) {
            this.screenResolution = screenWidth + "x" + screenHeight;
        }
        if (gs[0] != null) {
            this.colorDepth = gs[0].getDisplayMode().getBitDepth() + "";
            for (i = 1; i < gs.length; ++i) {
                this.colorDepth = this.colorDepth + ", " + gs[i].getDisplayMode().getBitDepth();
            }
        }
    }

    public String getColorDepth() {
        return this.colorDepth;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFlashVersion() {
        return this.flashVersion;
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getTrackingCode() {
        return this.trackingCode;
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public void setColorDepth(String argColorDepth) {
        this.colorDepth = argColorDepth;
    }

    public void setEncoding(String argEncoding) {
        this.encoding = argEncoding;
    }

    public void setFlashVersion(String argFlashVersion) {
        this.flashVersion = argFlashVersion;
    }

    public void setScreenResolution(String argScreenResolution) {
        this.screenResolution = argScreenResolution;
    }

    public void setUserLanguage(String argUserLanguage) {
        this.userLanguage = argUserLanguage;
    }
}

