/*
 * Decompiled with CFR 0.152.
 */
package com.dmurph.tracking;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.AnalyticsRequestData;
import com.dmurph.tracking.GoogleAnalyticsV4_7_2;
import com.dmurph.tracking.IGoogleAnalyticsURLBuilder;
import java.net.HttpURLConnection;
import java.net.URL;

public class JGoogleAnalyticsTracker {
    public static boolean DEBUG_PRINT = false;
    private static final ThreadGroup asyncThreadGroup = new ThreadGroup("Async Google Analytics Threads");
    private GoogleAnalyticsVersion gaVersion = null;
    private IGoogleAnalyticsURLBuilder builder = null;
    private AnalyticsConfigData configData = null;
    private boolean enabled = false;
    private boolean asynchronous = true;

    public JGoogleAnalyticsTracker(AnalyticsConfigData argConfigData, GoogleAnalyticsVersion argVersion) {
        this.gaVersion = argVersion;
        this.configData = argConfigData;
        this.createBuilder();
        this.enabled = true;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void resetSession() {
        this.builder.resetSession();
    }

    public void setEnabled(boolean argEnabled) {
        this.enabled = argEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void trackPageView(String argPageURL, String argPageTitle, String argHostName) {
        this.trackPageViewFromReferrer(argPageURL, argPageTitle, argHostName, "http://www.dmurph.com", "/");
    }

    public void trackPageViewFromReferrer(String argPageURL, String argPageTitle, String argHostName, String argReferrerSite, String argReferrerPage) {
        if (argPageURL == null) {
            throw new IllegalArgumentException("Page URL cannot be null, Google will not track the data.");
        }
        AnalyticsRequestData data = new AnalyticsRequestData();
        data.setHostName(argHostName);
        data.setPageTitle(argPageTitle);
        data.setPageURL(argPageURL);
        data.setReferer(argReferrerSite, argReferrerPage);
        this.makeCustomRequest(data);
    }

    public void trackPageViewFromSearch(String argPageURL, String argPageTitle, String argHostName, String argSearchSource, String argSearchKeywords) {
        if (argPageURL == null) {
            throw new IllegalArgumentException("Page URL cannot be null, Google will not track the data.");
        }
        AnalyticsRequestData data = new AnalyticsRequestData();
        data.setHostName(argHostName);
        data.setPageTitle(argPageTitle);
        data.setPageURL(argPageURL);
        data.setSeachReferrer(argSearchSource, argSearchKeywords);
        this.makeCustomRequest(data);
    }

    public void trackEvent(String argCategory, String argAction) {
        this.trackEvent(argCategory, argAction, null, null);
    }

    public void trackEvent(String argCategory, String argAction, String argLabel) {
        this.trackEvent(argCategory, argAction, argLabel, null);
    }

    public void trackEvent(String argCategory, String argAction, String argLabel, Integer argValue) {
        AnalyticsRequestData data = new AnalyticsRequestData();
        data.setEventCategory(argCategory);
        data.setEventAction(argAction);
        data.setEventLabel(argLabel);
        data.setEventValue(argValue);
        this.makeCustomRequest(data);
    }

    public synchronized void makeCustomRequest(AnalyticsRequestData argData) {
        if (!this.enabled) {
            if (DEBUG_PRINT) {
                System.out.println("Ignoring tracking request, enabled is true");
            }
            return;
        }
        if (argData == null) {
            throw new NullPointerException("Data cannot be null");
        }
        if (this.builder == null) {
            throw new NullPointerException("Class was not initialized");
        }
        final String url = this.builder.buildURL(argData);
        if (this.asynchronous) {
            Thread t = new Thread(asyncThreadGroup, "AnalyticThread-" + asyncThreadGroup.activeCount()){

                public void run() {
                    JGoogleAnalyticsTracker.this.dispatchRequest(url);
                }
            };
            t.start();
        } else {
            this.dispatchRequest(url);
        }
    }

    private void dispatchRequest(String argURL) {
        try {
            URL url = new URL(argURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setInstanceFollowRedirects(true);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                System.err.println("JGoogleAnalyticsTracker: Error requesting url '" + argURL + "', received response code " + responseCode);
            } else if (DEBUG_PRINT) {
                System.out.println("JGoogleAnalyticsTracker: Tracking success for url '" + argURL + "'");
            }
        }
        catch (Exception e) {
            System.err.println("Error making tracking request");
            e.printStackTrace();
        }
    }

    private void createBuilder() {
        switch (this.gaVersion) {
            case V_4_7_2: {
                this.builder = new GoogleAnalyticsV4_7_2(this.configData);
                break;
            }
            default: {
                this.builder = new GoogleAnalyticsV4_7_2(this.configData);
            }
        }
    }

    static {
        asyncThreadGroup.setMaxPriority(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GoogleAnalyticsVersion {
        V_4_7_2;

    }
}

