/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.auth;

import brave.Tracing;
import com.dnastack.audit.client.AuthHttpClient;
import com.dnastack.audit.model.AuditEventLoggerConfig;
import com.dnastack.audit.model.TokenResponse;
import interceptor.TokenDelegate;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenDelegate
implements TokenDelegate {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenDelegate.class);
    private static final Duration TOKEN_VALIDITY_BUFFER = Duration.ofSeconds(60L);
    private final AuthHttpClient authHttpClient;
    private TokenResponse tokenResponse;
    private Instant tokenRetrievedAt;

    public AccessTokenDelegate(AuditEventLoggerConfig.OAuthClient oAuthClientConfig, Tracing tracing) {
        Objects.requireNonNull(oAuthClientConfig);
        oAuthClientConfig.validate();
        this.authHttpClient = new AuthHttpClient(oAuthClientConfig, tracing);
    }

    public String getCurrentToken() {
        return this.getAccessToken();
    }

    public String getNewToken() {
        this.refreshAccessToken();
        return this.getAccessToken();
    }

    private synchronized String getAccessToken() {
        if (this.tokenResponse == null) {
            this.refreshAccessToken();
        } else if (this.tokenRetrievedAt.plusSeconds(this.tokenResponse.getExpiryInSeconds()).minus(TOKEN_VALIDITY_BUFFER).isBefore(Instant.now())) {
            log.debug("Access token has expired, or will be expiring within the buffer window. Refreshing token now");
            this.refreshAccessToken();
        }
        return this.tokenResponse.getAccessToken();
    }

    private synchronized void refreshAccessToken() {
        this.tokenResponse = this.authHttpClient.getTokenResponse();
        this.tokenRetrievedAt = Instant.now();
        log.debug("Successfully retrieved access token");
    }
}

