/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.client;

import brave.Tracing;
import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.exception.InvalidTokenResponseException;
import com.dnastack.audit.model.AuditEventLoggerConfig;
import com.dnastack.audit.model.TokenResponse;
import com.dnastack.auth.PermissionChecker;
import com.dnastack.auth.PermissionCheckerFactory;
import com.dnastack.auth.exception.HttpRequestFailedException;
import com.dnastack.auth.keyresolver.CachingIssuerPubKeyJwksResolver;
import com.dnastack.auth.keyresolver.IssuerPubKeyResolver;
import com.dnastack.auth.model.IssuerInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AuthHttpClient {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final ObjectMapper objectMapper = ObjectMapperFactory.create();
    private final AuditEventLoggerConfig.OAuthClient oAuthClientConfig;
    private final PermissionChecker permissionChecker;

    public AuthHttpClient(AuditEventLoggerConfig.OAuthClient oAuthClientConfig, Tracing tracing) {
        this.oAuthClientConfig = oAuthClientConfig;
        List allowedIssuers = oAuthClientConfig.getTokenIssuersUris().stream().distinct().map(issuerUri -> IssuerInfo.IssuerInfoBuilder.builder().issuerUri(issuerUri).allowedAudiences(List.of(oAuthClientConfig.getAudience())).publicKeyResolver((IssuerPubKeyResolver)new CachingIssuerPubKeyJwksResolver(issuerUri)).build()).collect(Collectors.toList());
        String policyEvaluationRequester = oAuthClientConfig.getPolicyEvaluationRequester();
        String policyEvaluationUri = oAuthClientConfig.getPolicyEvaluationUri();
        this.permissionChecker = PermissionCheckerFactory.create(allowedIssuers, (String)policyEvaluationRequester, (String)policyEvaluationUri, (Tracing)tracing);
    }

    public TokenResponse getTokenResponse() {
        String credentials = String.format("%s:%s", this.oAuthClientConfig.getClientId(), this.oAuthClientConfig.getClientSecret());
        String authHeader = String.format("Basic %s", Base64.getEncoder().encodeToString(credentials.getBytes()));
        URI uri = URI.create(String.format("%s?grant_type=client_credentials&resource=%s&scope=%s", this.oAuthClientConfig.getTokenUri(), this.oAuthClientConfig.getResource(), this.oAuthClientConfig.getScopes()));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", authHeader).POST(HttpRequest.BodyPublishers.noBody()).build();
        return this.getAndValidateResponse(request);
    }

    private TokenResponse getAndValidateResponse(HttpRequest request) {
        Map response = this.sendAndReceive(request, Map.class);
        if (response != null && response.containsKey("access_token")) {
            TokenResponse tokenResponse = (TokenResponse)this.objectMapper.convertValue((Object)response, TokenResponse.class);
            this.permissionChecker.checkPermissions(tokenResponse.getAccessToken(), Arrays.asList(this.oAuthClientConfig.getScopes().split(" ")), Map.of(this.oAuthClientConfig.getResource(), this.oAuthClientConfig.getActions()));
            return tokenResponse;
        }
        throw new InvalidTokenResponseException(String.format("Expected token response instead got response %s", response));
    }

    protected <T> T sendAndReceive(HttpRequest request, Class<T> responseType) {
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return (T)this.objectMapper.readValue(response.body(), responseType);
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpRequestFailedException(String.format("Failed request %s %s", request.method(), request.uri()), (Throwable)ex);
        }
    }
}

