/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.client;

import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.client.RetryInterceptor;
import com.dnastack.audit.exception.HttpRequestFailedException;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.AuditEventBodyBatch;
import com.dnastack.audit.model.AuditEventLoggerConfig;
import com.dnastack.audit.util.AuditTracer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import interceptor.AuthorizationInterceptor;
import interceptor.TokenDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsClient {
    private static final Logger log = LoggerFactory.getLogger(EventsClient.class);
    private final AuditEventLoggerConfig.Publisher publisherConfig;
    private final ObjectMapper objectMapper;
    private final AuditTracer auditTracer;
    private final OkHttpClient eventsHttpClient;

    public EventsClient(AuditEventLoggerConfig.Publisher publisherConfig, TokenDelegate tokenDelegate, AuditTracer auditTracer) {
        Objects.requireNonNull(publisherConfig, "publisherConfig must not be null");
        Objects.requireNonNull(tokenDelegate, "accessTokenSupplier must not be null");
        Objects.requireNonNull(auditTracer, "auditTracer must not be null");
        this.publisherConfig = publisherConfig;
        this.objectMapper = ObjectMapperFactory.create();
        this.auditTracer = auditTracer;
        this.eventsHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)log).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BASIC)).addInterceptor((Interceptor)new AuthorizationInterceptor(tokenDelegate)).addInterceptor((Interceptor)new RetryInterceptor(publisherConfig.getGiveUpAfter(), publisherConfig.getDelayBetweenTriesInMillis())).build();
    }

    public void publishBatch(final AuditEventBodyBatch auditEventBodyBatch) {
        try {
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.get((String)"application/json");
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    OutputStream os = sink.outputStream();
                    EventsClient.this.objectMapper.writeValue(os, (Object)auditEventBodyBatch);
                }
            };
            Request request = new Request.Builder().url(this.publisherConfig.getEventsBatchUri()).header("Content-Type", "application/json").header("X-B3-TraceId", this.auditTracer.currentTraceId()).header("X-B3-SpanId", this.auditTracer.currentSpanId()).method("POST", requestBody).build();
            log.info("Preparing batch request [{}] [{}] - number of events in batch: [{}], content length: [{}] Bytes", new Object[]{request.method(), request.url(), auditEventBodyBatch.getEvents().size(), request.body() != null ? Long.valueOf(request.body().contentLength()) : "unknown"});
            this.send(request);
        }
        catch (JsonProcessingException | MalformedURLException ex) {
            throw new HttpRequestFailedException(String.format("Failed to process %s", auditEventBodyBatch), ex);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public void publish(final AuditEventBody auditEvent) {
        try {
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.get((String)"application/json");
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    OutputStream os = sink.outputStream();
                    EventsClient.this.objectMapper.writeValue(os, (Object)auditEvent);
                }
            };
            Request request = new Request.Builder().url(this.publisherConfig.getEventsUri()).header("Content-Type", "application/json").header("X-B3-TraceId", this.auditTracer.currentTraceId()).header("X-B3-SpanId", this.auditTracer.currentSpanId()).method("POST", requestBody).build();
            log.info("Preparing single request [{}] [{}] - content length: [{}] Bytes", new Object[]{request.method(), request.url(), request.body() != null ? Long.valueOf(request.body().contentLength()) : "unknown"});
            this.send(request);
        }
        catch (JsonProcessingException | MalformedURLException ex) {
            throw new HttpRequestFailedException(String.format("Failed to process %s", auditEvent), ex);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private void send(Request request) {
        try (Response response = this.eventsHttpClient.newCall(request).execute();){
            if (response.code() == 200 && response.body() != null) {
                AuditEventBodyBatch auditEventBodyBatch = (AuditEventBodyBatch)this.objectMapper.readValue(response.body().charStream(), AuditEventBodyBatch.class);
                if (auditEventBodyBatch.getEvents() != null) {
                    auditEventBodyBatch.getEvents().forEach(auditEventBody -> log.error("Failed to store Audit Event {} ", auditEventBody));
                }
            } else if (!response.isSuccessful()) {
                log.warn("Failed request [{}] [{}] after [{}] retries with status [{}]", new Object[]{request.method(), request.url(), this.publisherConfig.getGiveUpAfter(), response.code()});
                this.auditTracer.setCurrentSpanError(new HttpRequestFailedException(String.format("Failed request [%s] [%s] after [%s] retries with status [%s]", request.method(), request.url(), this.publisherConfig.getGiveUpAfter(), response.code())));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            this.auditTracer.setCurrentSpanError(e);
        }
        catch (RuntimeException re) {
            this.auditTracer.setCurrentSpanError(re);
            throw re;
        }
    }
}

