/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.client;

import com.dnastack.audit.exception.InvalidRetryConfigurationException;
import io.github.resilience4j.core.IntervalFunction;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RetryInterceptor.class);
    private final Integer maxNumberOfTries;
    private final IntervalFunction defaultRateLimitFunction;

    public RetryInterceptor(Integer maxNumberOfTries, Long delayBetweenTriesInMillis) {
        this.validateRetryConfiguration(maxNumberOfTries, delayBetweenTriesInMillis);
        this.maxNumberOfTries = maxNumberOfTries;
        this.defaultRateLimitFunction = IntervalFunction.ofExponentialRandomBackoff((long)delayBetweenTriesInMillis, (double)2.0, (long)1000L);
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        int tryCount = 0;
        while (!response.isSuccessful() && response.code() != 401 && tryCount < this.maxNumberOfTries) {
            log.warn("Request [{}] [{}] failed with status [{}] and will be retried.", new Object[]{request.method(), request.url(), response.code()});
            long expDelay = (Long)this.defaultRateLimitFunction.apply((Object)(++tryCount));
            try {
                TimeUnit.MILLISECONDS.sleep(expDelay);
                response.close();
                response = chain.proceed(request);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return response;
    }

    private void validateRetryConfiguration(Integer maxNumberOfTries, Long delayBetweenTriesInMillis) {
        if (maxNumberOfTries < 0) {
            throw new InvalidRetryConfigurationException("Max number of retries must be a non-negative number.");
        }
        if (maxNumberOfTries < 1) {
            throw new InvalidRetryConfigurationException("Cannot specify a maximum number of tries less than 1!");
        }
        if (delayBetweenTriesInMillis < 0L) {
            throw new InvalidRetryConfigurationException("Delay between retries must be a non-negative Duration.");
        }
    }
}

