/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.diff;

import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.diff.JsonPatchDiff;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;

public class JsonPatchDiffProvider {
    private static final Pattern pattern = Pattern.compile("\\d+");
    private static final ObjectMapper objectMapper = ObjectMapperFactory.create();

    public static List<JsonPatchDiff> getDiff(Object source, Object target) {
        JsonNode jsonSource = source != null ? (JsonNode)objectMapper.convertValue(source, JsonNode.class) : null;
        JsonNode jsonTarget = target != null ? (JsonNode)objectMapper.convertValue(target, JsonNode.class) : null;
        JsonNode patch = JsonDiff.asJson((JsonNode)jsonSource, (JsonNode)jsonTarget, (EnumSet)DiffFlags.dontNormalizeOpIntoMoveAndCopy().clone());
        TypeReference<List<JsonPatchDiff>> type = new TypeReference<List<JsonPatchDiff>>(){};
        List jsonDiffPatches = (List)objectMapper.convertValue((Object)patch, (TypeReference)type);
        JsonNode intermediateObject = jsonSource;
        for (JsonPatchDiff patchDiff : jsonDiffPatches) {
            if ("remove".equalsIgnoreCase(patchDiff.getOp())) {
                patchDiff.setOriginalValue(intermediateObject.at(patchDiff.getPath()));
                patchDiff.setValue(null);
            }
            if ("replace".equalsIgnoreCase(patchDiff.getOp())) {
                patchDiff.setOriginalValue(intermediateObject.at(patchDiff.getPath()));
            }
            if ("add".equalsIgnoreCase(patchDiff.getOp()) && intermediateObject == null) {
                intermediateObject = (JsonNode)objectMapper.convertValue(patchDiff.getValue(), JsonNode.class);
                patchDiff.setContext(JsonPatchDiffProvider.prepareContext(intermediateObject, patchDiff.getPath()));
                continue;
            }
            if ("remove".equalsIgnoreCase(patchDiff.getOp()) && "".equalsIgnoreCase(patchDiff.getPath())) {
                patchDiff.setContext(JsonPatchDiffProvider.prepareContext(intermediateObject, patchDiff.getPath()));
                intermediateObject = objectMapper.nullNode();
                continue;
            }
            intermediateObject = JsonPatch.apply((JsonNode)((JsonNode)objectMapper.convertValue(List.of(patchDiff), JsonNode.class)), (JsonNode)intermediateObject);
            patchDiff.setContext(JsonPatchDiffProvider.prepareContext(intermediateObject, patchDiff.getPath()));
        }
        return jsonDiffPatches;
    }

    private static JsonNode prepareContext(JsonNode object, String patchPath) {
        JsonNode context = object.deepCopy();
        if (context.at(patchPath).isValueNode()) {
            context.at(patchPath.substring(0, patchPath.lastIndexOf("/"))).fields().forEachRemaining(entry -> {
                if (((JsonNode)entry.getValue()).isArray()) {
                    ((ArrayNode)entry.getValue()).removeAll();
                }
            });
        } else if (context.at(patchPath).isObject()) {
            context.at(patchPath).fields().forEachRemaining(entry -> {
                if (((JsonNode)entry.getValue()).isArray()) {
                    ((ArrayNode)entry.getValue()).removeAll();
                }
            });
        }
        String[] pathArray = patchPath.split("/");
        for (int i = 0; i < pathArray.length; ++i) {
            if (!pattern.matcher(pathArray[i]).matches() || i == pathArray.length - 1) continue;
            String path = String.join((CharSequence)"/", Arrays.copyOfRange(pathArray, 0, i));
            ArrayNode arrayNode = (ArrayNode)context.at(path);
            JsonNode nodeToKeep = arrayNode.get(Integer.parseInt(pathArray[i]));
            arrayNode.removeAll();
            arrayNode.add(nodeToKeep);
            pathArray[i] = "0";
        }
        return context;
    }
}

