/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.emitter;

import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.exception.FailedToWriteJsonException;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.JsonPrinterStyle;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.airlift.log.Logger;

public class AirliftAuditEventLogEmitter
implements AuditEventLogEmitter {
    private final Logger logger = Logger.get(AirliftAuditEventLogEmitter.class);
    private final ObjectWriter objectWriter;

    public AirliftAuditEventLogEmitter(JsonPrinterStyle jsonPrinterStyle) {
        this.objectWriter = ObjectMapperFactory.createWrite(jsonPrinterStyle);
    }

    @Override
    public void emit(AuditEventBody auditEvent) {
        try {
            this.logger.info("%s", new Object[]{this.objectWriter.writeValueAsString((Object)auditEvent)});
        }
        catch (JsonProcessingException e) {
            String errorMessage = String.format("[%s | %s] Could not write JSON from %s", auditEvent.getContext().getTraceId(), auditEvent.getContext().getSpanId(), auditEvent);
            throw new FailedToWriteJsonException(errorMessage, e);
        }
    }
}

