/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.emitter;

import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.exception.FailedToWriteJsonException;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.JsonPrinterStyle;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jAuditEventLogEmitter
implements AuditEventLogEmitter {
    private final Logger logger = LoggerFactory.getLogger(Slf4jAuditEventLogEmitter.class);
    private final ObjectWriter objectWriter;

    public Slf4jAuditEventLogEmitter(JsonPrinterStyle jsonPrinterStyle) {
        this.objectWriter = ObjectMapperFactory.createWrite(jsonPrinterStyle);
    }

    @Override
    public void emit(AuditEventBody auditEvent) {
        try {
            String auditEventJson = this.objectWriter.writeValueAsString((Object)auditEvent);
            this.logger.info("{}", (Object)auditEventJson);
        }
        catch (JsonProcessingException ex) {
            String errorMessage = String.format("[%s | %s] Could not write JSON from %s", auditEvent.getContext().getTraceId(), auditEvent.getContext().getSpanId(), auditEvent);
            throw new FailedToWriteJsonException(errorMessage, ex);
        }
    }
}

