/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.logger;

import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.emitter.EventsAuditEventLogEmitter;
import com.dnastack.audit.emitter.Slf4jAuditEventLogEmitter;
import com.dnastack.audit.logger.EmittingAuditEventLogger;
import com.dnastack.audit.model.AuditEventLoggerConfig;
import com.dnastack.audit.util.AuditTracer;
import interceptor.TokenDelegate;
import java.util.List;

public final class AuditEventLoggerFactory {
    private AuditEventLoggerFactory() {
    }

    public static EmittingAuditEventLogger create(AuditEventLoggerConfig config, TokenDelegate tokenDelegate, AuditTracer auditTracer) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (config.getPublisher() == null) {
            throw new IllegalArgumentException("publisher config must not be null");
        }
        config.getPublisher().validate();
        if (tokenDelegate == null) {
            throw new IllegalArgumentException("access token supplier must not be null");
        }
        return AuditEventLoggerFactory.create(List.of(new EventsAuditEventLogEmitter(config.getPublisher(), tokenDelegate, auditTracer), new Slf4jAuditEventLogEmitter(config.getJsonPrinterStyle())));
    }

    public static EmittingAuditEventLogger create(List<AuditEventLogEmitter> emitters) {
        if (emitters == null || emitters.isEmpty()) {
            throw new IllegalArgumentException("emitters must not be null or empty");
        }
        return new EmittingAuditEventLogger(emitters);
    }
}

