/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.logger;

import com.dnastack.audit.diff.JsonPatchDiffProvider;
import com.dnastack.audit.exception.InvalidActionExecutorStateException;
import com.dnastack.audit.logger.AuditEventLogger;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.AuditEventOutcome;
import com.dnastack.audit.model.AuditedAction;
import com.dnastack.audit.model.AuditedContext;
import com.dnastack.audit.model.AuditedOutcome;
import com.dnastack.audit.model.AuditedResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class AuditableActionExecutor {
    private AuditableActionExecutor() {
    }

    public static AuditableSingleActionExecutionStageBuilder<?> create(AuditEventLogger auditEventLogger, String actionUri, String resourcePath) {
        return new AuditableSingleActionExecutionStageBuilder(auditEventLogger, actionUri, resourcePath);
    }

    public static class AuditableSingleActionExecutionStageBuilder<R> {
        private final AuditEventLogger auditEventLogger;
        private final String actionUri;
        private final String resourceUri;
        private boolean logStarted = false;
        private Map<String, Object> extraArgumentsForStarted;
        private boolean logCompleted = false;
        private Function<R, Map<String, Object>> extraArgumentsForCompletedFunction;
        private Supplier<Map<String, Object>> extraArgumentsForCompletedSupplier;
        private boolean logFailed = false;
        private Function<Throwable, Map<String, Object>> extraArgumentsForFailedFunction;
        private Function<AuditedContext, R> actionFunction;
        private final AuditedContext auditedContext = new AuditedContext();

        public AuditableSingleActionExecutionStageBuilder(AuditEventLogger auditEventLogger, String actionUri, String resourceUri) {
            this.auditEventLogger = auditEventLogger;
            this.actionUri = actionUri;
            this.resourceUri = resourceUri;
        }

        public AuditableSingleActionExecutionStageBuilder<R> logStarted(Map<String, Object> extraArguments) {
            this.logStarted = true;
            this.extraArgumentsForStarted = extraArguments;
            return this;
        }

        public <U> AuditableSingleActionExecutionStageBuilder<U> action(Function<AuditedContext, U> action) {
            this.actionFunction = action;
            return this;
        }

        public AuditableSingleActionExecutionStageBuilder<R> logCompleted(Function<R, Map<String, Object>> extraArgumentsFunction) {
            this.logCompleted = true;
            this.extraArgumentsForCompletedFunction = extraArgumentsFunction;
            return this;
        }

        public AuditableSingleActionExecutionStageBuilder<R> logCompleted(Supplier<Map<String, Object>> extraArgumentsSupplier) {
            this.logCompleted = true;
            this.extraArgumentsForCompletedSupplier = extraArgumentsSupplier;
            return this;
        }

        public AuditableSingleActionExecutionStageBuilder<R> logFailed(Function<Throwable, Map<String, Object>> extraArgumentsFunction) {
            this.logFailed = true;
            this.extraArgumentsForFailedFunction = extraArgumentsFunction;
            return this;
        }

        public R execute() {
            if (this.actionFunction == null) {
                throw new InvalidActionExecutorStateException("Single action must be set");
            }
            if (this.logStarted) {
                this.log(this.extraArgumentsForStarted, AuditEventOutcome.STARTED, this.auditedContext);
            }
            try {
                Map<String, Object> extraArguments;
                R result = this.actionFunction.apply(this.auditedContext);
                Map<String, Object> map = extraArguments = this.extraArgumentsForCompletedSupplier != null ? this.extraArgumentsForCompletedSupplier.get() : this.extraArgumentsForCompletedFunction.apply(result);
                if (this.auditedContext.getLogSubjectBeforeAction() != null && this.auditedContext.getLogSubjectAfterAction() != null && this.logCompleted) {
                    this.log(this.getExtraArgumentsWithDiff(extraArguments, this.auditedContext.getLogSubjectBeforeAction(), this.auditedContext.getLogSubjectAfterAction()), AuditEventOutcome.COMPLETED, this.auditedContext);
                    return result;
                }
                if (this.logCompleted) {
                    this.log(extraArguments, AuditEventOutcome.COMPLETED, this.auditedContext);
                }
                return result;
            }
            catch (Exception ex) {
                Map<String, Object> extraArguments = this.extraArgumentsForFailedFunction.apply(ex);
                if (this.logFailed) {
                    this.log(extraArguments, AuditEventOutcome.FAILED, this.auditedContext);
                }
                throw ex;
            }
        }

        private void log(Map<String, Object> extraArguments, AuditEventOutcome state, AuditedContext context) {
            this.auditEventLogger.log(AuditEventBody.builder().action(AuditedAction.builder().uri(this.actionUri).build()).resource(AuditedResource.builder().uri(this.resourceUri).build()).outcome(AuditedOutcome.builder().operationState(state).build()).context(context).extraArguments(extraArguments).build());
        }

        private Map<String, Object> getExtraArgumentsWithDiff(Map<String, Object> extraArguments, Object logSubjectBeforeAction, Object logSubjectAfterAction) {
            HashMap<String, Object> extraArgumentsWithDiff = new HashMap<String, Object>(extraArguments);
            extraArgumentsWithDiff.put("diff", JsonPatchDiffProvider.getDiff(logSubjectBeforeAction, logSubjectAfterAction));
            return Collections.unmodifiableMap(extraArgumentsWithDiff);
        }
    }
}

