/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.logger;

import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.exception.AccumulatedEmitterException;
import com.dnastack.audit.logger.AuditEventLogger;
import com.dnastack.audit.model.AuditEventBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EmittingAuditEventLogger
implements AuditEventLogger {
    private final List<AuditEventLogEmitter> emitters;

    public List<AuditEventLogEmitter> getEmitters() {
        return Collections.unmodifiableList(this.emitters);
    }

    public EmittingAuditEventLogger(List<AuditEventLogEmitter> emitters) {
        if (emitters == null || emitters.isEmpty()) {
            throw new IllegalArgumentException("emitters must not be null or empty");
        }
        this.emitters = emitters;
    }

    @Override
    public void log(AuditEventBody auditEvent) {
        Objects.requireNonNull(auditEvent, "auditEvent must not be null");
        Objects.requireNonNull(auditEvent.getContext().getTraceId(), "auditEvent trace id must not be null");
        Objects.requireNonNull(auditEvent.getContext().getSpanId(), "auditEvent span id must not be null");
        ArrayList accumulatedExceptions = new ArrayList();
        this.emitters.forEach(emitter -> {
            try {
                emitter.emit(auditEvent);
            }
            catch (Exception ex) {
                accumulatedExceptions.add(ex);
            }
        });
        if (!accumulatedExceptions.isEmpty()) {
            AccumulatedEmitterException accumulatedException = new AccumulatedEmitterException("Got exceptions during emitting logs");
            accumulatedExceptions.forEach(accumulatedException::addSuppressed);
            throw accumulatedException;
        }
    }
}

