/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.model;

import com.dnastack.audit.model.AuditedAction;
import com.dnastack.audit.model.AuditedContext;
import com.dnastack.audit.model.AuditedOutcome;
import com.dnastack.audit.model.AuditedPrincipal;
import com.dnastack.audit.model.AuditedResource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuditEventBody {
    private AuditedPrincipal principal;
    private AuditedResource resource;
    private AuditedAction action;
    private AuditedOutcome outcome;
    private Instant timestamp;
    private AuditedContext context;
    @JsonProperty(value="extra_arguments")
    private Map<String, Object> extraArguments;

    public void putExtraArgument(String key, Object value) {
        if (this.extraArguments == null) {
            this.extraArguments = new HashMap<String, Object>();
        }
        this.extraArguments.put(key, value);
    }

    public void putExtraArguments(Map<String, Object> arguments) {
        if (this.extraArguments == null) {
            this.extraArguments = new HashMap<String, Object>();
        }
        this.extraArguments.putAll(arguments);
    }

    public static AuditEventBodyBuilder builder() {
        return new AuditEventBodyBuilder();
    }

    public AuditedPrincipal getPrincipal() {
        return this.principal;
    }

    public AuditedResource getResource() {
        return this.resource;
    }

    public AuditedAction getAction() {
        return this.action;
    }

    public AuditedOutcome getOutcome() {
        return this.outcome;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public AuditedContext getContext() {
        return this.context;
    }

    public Map<String, Object> getExtraArguments() {
        return this.extraArguments;
    }

    public void setPrincipal(AuditedPrincipal principal) {
        this.principal = principal;
    }

    public void setResource(AuditedResource resource) {
        this.resource = resource;
    }

    public void setAction(AuditedAction action) {
        this.action = action;
    }

    public void setOutcome(AuditedOutcome outcome) {
        this.outcome = outcome;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public void setContext(AuditedContext context) {
        this.context = context;
    }

    @JsonProperty(value="extra_arguments")
    public void setExtraArguments(Map<String, Object> extraArguments) {
        this.extraArguments = extraArguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditEventBody)) {
            return false;
        }
        AuditEventBody other = (AuditEventBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AuditedPrincipal this$principal = this.getPrincipal();
        AuditedPrincipal other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal)) {
            return false;
        }
        AuditedResource this$resource = this.getResource();
        AuditedResource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        AuditedAction this$action = this.getAction();
        AuditedAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        AuditedOutcome this$outcome = this.getOutcome();
        AuditedOutcome other$outcome = other.getOutcome();
        if (this$outcome == null ? other$outcome != null : !((Object)this$outcome).equals(other$outcome)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        AuditedContext this$context = this.getContext();
        AuditedContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        Map<String, Object> this$extraArguments = this.getExtraArguments();
        Map<String, Object> other$extraArguments = other.getExtraArguments();
        return !(this$extraArguments == null ? other$extraArguments != null : !((Object)this$extraArguments).equals(other$extraArguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditEventBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuditedPrincipal $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        AuditedResource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        AuditedAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        AuditedOutcome $outcome = this.getOutcome();
        result = result * 59 + ($outcome == null ? 43 : ((Object)$outcome).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        AuditedContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        Map<String, Object> $extraArguments = this.getExtraArguments();
        result = result * 59 + ($extraArguments == null ? 43 : ((Object)$extraArguments).hashCode());
        return result;
    }

    public String toString() {
        return "AuditEventBody(principal=" + String.valueOf(this.getPrincipal()) + ", resource=" + String.valueOf(this.getResource()) + ", action=" + String.valueOf(this.getAction()) + ", outcome=" + String.valueOf(this.getOutcome()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", context=" + String.valueOf(this.getContext()) + ", extraArguments=" + String.valueOf(this.getExtraArguments()) + ")";
    }

    public AuditEventBody() {
    }

    public AuditEventBody(AuditedPrincipal principal, AuditedResource resource, AuditedAction action, AuditedOutcome outcome, Instant timestamp, AuditedContext context, Map<String, Object> extraArguments) {
        this.principal = principal;
        this.resource = resource;
        this.action = action;
        this.outcome = outcome;
        this.timestamp = timestamp;
        this.context = context;
        this.extraArguments = extraArguments;
    }

    public static class AuditEventBodyBuilder {
        private AuditedPrincipal principal;
        private AuditedResource resource;
        private AuditedAction action;
        private AuditedOutcome outcome;
        private Instant timestamp;
        private AuditedContext context;
        private Map<String, Object> extraArguments;

        AuditEventBodyBuilder() {
        }

        public AuditEventBodyBuilder principal(AuditedPrincipal principal) {
            this.principal = principal;
            return this;
        }

        public AuditEventBodyBuilder resource(AuditedResource resource) {
            this.resource = resource;
            return this;
        }

        public AuditEventBodyBuilder action(AuditedAction action) {
            this.action = action;
            return this;
        }

        public AuditEventBodyBuilder outcome(AuditedOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public AuditEventBodyBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public AuditEventBodyBuilder context(AuditedContext context) {
            this.context = context;
            return this;
        }

        @JsonProperty(value="extra_arguments")
        public AuditEventBodyBuilder extraArguments(Map<String, Object> extraArguments) {
            this.extraArguments = extraArguments;
            return this;
        }

        public AuditEventBody build() {
            return new AuditEventBody(this.principal, this.resource, this.action, this.outcome, this.timestamp, this.context, this.extraArguments);
        }

        public String toString() {
            return "AuditEventBody.AuditEventBodyBuilder(principal=" + String.valueOf(this.principal) + ", resource=" + String.valueOf(this.resource) + ", action=" + String.valueOf(this.action) + ", outcome=" + String.valueOf(this.outcome) + ", timestamp=" + String.valueOf(this.timestamp) + ", context=" + String.valueOf(this.context) + ", extraArguments=" + String.valueOf(this.extraArguments) + ")";
        }
    }
}

