/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.model;

import com.dnastack.audit.model.JsonPrinterStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AuditEventLoggerConfig {
    private JsonPrinterStyle jsonPrinterStyle = JsonPrinterStyle.PRETTY_PRINT;
    private Publisher publisher;

    private static String removeTrailingSlash(String topicsUri) {
        if (topicsUri != null && !topicsUri.isBlank() && topicsUri.endsWith("/")) {
            return topicsUri.substring(0, topicsUri.length() - 1);
        }
        return topicsUri;
    }

    public JsonPrinterStyle getJsonPrinterStyle() {
        return this.jsonPrinterStyle;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public void setJsonPrinterStyle(JsonPrinterStyle jsonPrinterStyle) {
        this.jsonPrinterStyle = jsonPrinterStyle;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditEventLoggerConfig)) {
            return false;
        }
        AuditEventLoggerConfig other = (AuditEventLoggerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonPrinterStyle this$jsonPrinterStyle = this.getJsonPrinterStyle();
        JsonPrinterStyle other$jsonPrinterStyle = other.getJsonPrinterStyle();
        if (this$jsonPrinterStyle == null ? other$jsonPrinterStyle != null : !((Object)((Object)this$jsonPrinterStyle)).equals((Object)other$jsonPrinterStyle)) {
            return false;
        }
        Publisher this$publisher = this.getPublisher();
        Publisher other$publisher = other.getPublisher();
        return !(this$publisher == null ? other$publisher != null : !((Object)this$publisher).equals(other$publisher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditEventLoggerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonPrinterStyle $jsonPrinterStyle = this.getJsonPrinterStyle();
        result = result * 59 + ($jsonPrinterStyle == null ? 43 : ((Object)((Object)$jsonPrinterStyle)).hashCode());
        Publisher $publisher = this.getPublisher();
        result = result * 59 + ($publisher == null ? 43 : ((Object)$publisher).hashCode());
        return result;
    }

    public String toString() {
        return "AuditEventLoggerConfig(jsonPrinterStyle=" + String.valueOf((Object)this.getJsonPrinterStyle()) + ", publisher=" + String.valueOf(this.getPublisher()) + ")";
    }

    public AuditEventLoggerConfig() {
    }

    public AuditEventLoggerConfig(JsonPrinterStyle jsonPrinterStyle, Publisher publisher) {
        this.jsonPrinterStyle = jsonPrinterStyle;
        this.publisher = publisher;
    }

    public static class Publisher {
        private String eventsUri;
        private String eventsBatchUri;
        private Integer giveUpAfter;
        private Long delayBetweenTriesInMillis;

        public void setEventsUri(String eventsUri) {
            this.eventsUri = AuditEventLoggerConfig.removeTrailingSlash(eventsUri);
        }

        public void validate() {
            if ((this.eventsUri == null || this.eventsUri.isBlank()) && (this.eventsBatchUri == null || this.eventsBatchUri.isBlank())) {
                throw new IllegalArgumentException("eventsUri/eventsBatchUri must not be null or blank");
            }
            if (this.delayBetweenTriesInMillis == null || this.delayBetweenTriesInMillis < 1L) {
                throw new IllegalArgumentException("delayBetweenTriesInMillis must not be null or negative number");
            }
            if (this.giveUpAfter == null || this.giveUpAfter < 1) {
                throw new IllegalArgumentException("giveUpAfter must not be null or negative number");
            }
        }

        public static PublisherBuilder builder() {
            return new PublisherBuilder();
        }

        public String getEventsUri() {
            return this.eventsUri;
        }

        public String getEventsBatchUri() {
            return this.eventsBatchUri;
        }

        public Integer getGiveUpAfter() {
            return this.giveUpAfter;
        }

        public Long getDelayBetweenTriesInMillis() {
            return this.delayBetweenTriesInMillis;
        }

        public void setEventsBatchUri(String eventsBatchUri) {
            this.eventsBatchUri = eventsBatchUri;
        }

        public void setGiveUpAfter(Integer giveUpAfter) {
            this.giveUpAfter = giveUpAfter;
        }

        public void setDelayBetweenTriesInMillis(Long delayBetweenTriesInMillis) {
            this.delayBetweenTriesInMillis = delayBetweenTriesInMillis;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Publisher)) {
                return false;
            }
            Publisher other = (Publisher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$giveUpAfter = this.getGiveUpAfter();
            Integer other$giveUpAfter = other.getGiveUpAfter();
            if (this$giveUpAfter == null ? other$giveUpAfter != null : !((Object)this$giveUpAfter).equals(other$giveUpAfter)) {
                return false;
            }
            Long this$delayBetweenTriesInMillis = this.getDelayBetweenTriesInMillis();
            Long other$delayBetweenTriesInMillis = other.getDelayBetweenTriesInMillis();
            if (this$delayBetweenTriesInMillis == null ? other$delayBetweenTriesInMillis != null : !((Object)this$delayBetweenTriesInMillis).equals(other$delayBetweenTriesInMillis)) {
                return false;
            }
            String this$eventsUri = this.getEventsUri();
            String other$eventsUri = other.getEventsUri();
            if (this$eventsUri == null ? other$eventsUri != null : !this$eventsUri.equals(other$eventsUri)) {
                return false;
            }
            String this$eventsBatchUri = this.getEventsBatchUri();
            String other$eventsBatchUri = other.getEventsBatchUri();
            return !(this$eventsBatchUri == null ? other$eventsBatchUri != null : !this$eventsBatchUri.equals(other$eventsBatchUri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Publisher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $giveUpAfter = this.getGiveUpAfter();
            result = result * 59 + ($giveUpAfter == null ? 43 : ((Object)$giveUpAfter).hashCode());
            Long $delayBetweenTriesInMillis = this.getDelayBetweenTriesInMillis();
            result = result * 59 + ($delayBetweenTriesInMillis == null ? 43 : ((Object)$delayBetweenTriesInMillis).hashCode());
            String $eventsUri = this.getEventsUri();
            result = result * 59 + ($eventsUri == null ? 43 : $eventsUri.hashCode());
            String $eventsBatchUri = this.getEventsBatchUri();
            result = result * 59 + ($eventsBatchUri == null ? 43 : $eventsBatchUri.hashCode());
            return result;
        }

        public String toString() {
            return "AuditEventLoggerConfig.Publisher(eventsUri=" + this.getEventsUri() + ", eventsBatchUri=" + this.getEventsBatchUri() + ", giveUpAfter=" + this.getGiveUpAfter() + ", delayBetweenTriesInMillis=" + this.getDelayBetweenTriesInMillis() + ")";
        }

        public Publisher() {
        }

        public Publisher(String eventsUri, String eventsBatchUri, Integer giveUpAfter, Long delayBetweenTriesInMillis) {
            this.eventsUri = eventsUri;
            this.eventsBatchUri = eventsBatchUri;
            this.giveUpAfter = giveUpAfter;
            this.delayBetweenTriesInMillis = delayBetweenTriesInMillis;
        }

        public static class PublisherBuilder {
            private String eventsBatchUri;
            private Integer giveUpAfter;
            private Long delayBetweenTriesInMillis;
            private String eventsUri;

            public PublisherBuilder eventsUri(String eventsUri) {
                this.eventsUri = AuditEventLoggerConfig.removeTrailingSlash(eventsUri);
                return this;
            }

            PublisherBuilder() {
            }

            public PublisherBuilder eventsBatchUri(String eventsBatchUri) {
                this.eventsBatchUri = eventsBatchUri;
                return this;
            }

            public PublisherBuilder giveUpAfter(Integer giveUpAfter) {
                this.giveUpAfter = giveUpAfter;
                return this;
            }

            public PublisherBuilder delayBetweenTriesInMillis(Long delayBetweenTriesInMillis) {
                this.delayBetweenTriesInMillis = delayBetweenTriesInMillis;
                return this;
            }

            public Publisher build() {
                return new Publisher(this.eventsUri, this.eventsBatchUri, this.giveUpAfter, this.delayBetweenTriesInMillis);
            }

            public String toString() {
                return "AuditEventLoggerConfig.Publisher.PublisherBuilder(eventsUri=" + this.eventsUri + ", eventsBatchUri=" + this.eventsBatchUri + ", giveUpAfter=" + this.giveUpAfter + ", delayBetweenTriesInMillis=" + this.delayBetweenTriesInMillis + ")";
            }
        }
    }

    public static class OAuthClient {
        private String tokenUri;
        private String clientId;
        private String clientSecret;
        private String scopes = null;
        private String resource = null;
        private Set<String> actions = new HashSet<String>();
        private String audience;
        private List<String> tokenIssuersUris = new ArrayList<String>();
        private String policyEvaluationRequester;
        private String policyEvaluationUri;

        public void validate() {
            if (this.tokenUri == null) {
                throw new IllegalArgumentException("token URI must not be null");
            }
            if (this.clientId == null || this.clientId.isBlank()) {
                throw new IllegalArgumentException("client id must not be null or blank");
            }
            if (this.clientSecret == null || this.clientSecret.isBlank()) {
                throw new IllegalArgumentException("client secret must not be null or blank");
            }
            if (this.scopes == null || this.scopes.isBlank()) {
                throw new IllegalArgumentException("scopes must not be null or blank");
            }
            if (this.resource == null || this.resource.isBlank()) {
                throw new IllegalArgumentException("resource must not be null or blank");
            }
            if (this.actions == null || this.actions.isEmpty()) {
                throw new IllegalArgumentException("actions must not be null or empty");
            }
            if (this.audience == null || this.audience.isBlank()) {
                throw new IllegalArgumentException("audience must not be null or blank");
            }
            if (this.tokenIssuersUris == null || this.tokenIssuersUris.isEmpty()) {
                throw new IllegalArgumentException("resource must not be null or empty");
            }
            if (this.policyEvaluationRequester == null || this.policyEvaluationRequester.isEmpty()) {
                throw new IllegalArgumentException("policy evaluation requester must not be null or empty");
            }
            if (this.policyEvaluationUri == null || this.policyEvaluationUri.isEmpty()) {
                throw new IllegalArgumentException("policy evaluation uri must not be null or empty");
            }
        }

        public String getTokenUri() {
            return this.tokenUri;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public String getScopes() {
            return this.scopes;
        }

        public String getResource() {
            return this.resource;
        }

        public Set<String> getActions() {
            return this.actions;
        }

        public String getAudience() {
            return this.audience;
        }

        public List<String> getTokenIssuersUris() {
            return this.tokenIssuersUris;
        }

        public String getPolicyEvaluationRequester() {
            return this.policyEvaluationRequester;
        }

        public String getPolicyEvaluationUri() {
            return this.policyEvaluationUri;
        }

        public void setTokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public void setScopes(String scopes) {
            this.scopes = scopes;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setActions(Set<String> actions) {
            this.actions = actions;
        }

        public void setAudience(String audience) {
            this.audience = audience;
        }

        public void setTokenIssuersUris(List<String> tokenIssuersUris) {
            this.tokenIssuersUris = tokenIssuersUris;
        }

        public void setPolicyEvaluationRequester(String policyEvaluationRequester) {
            this.policyEvaluationRequester = policyEvaluationRequester;
        }

        public void setPolicyEvaluationUri(String policyEvaluationUri) {
            this.policyEvaluationUri = policyEvaluationUri;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuthClient)) {
                return false;
            }
            OAuthClient other = (OAuthClient)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tokenUri = this.getTokenUri();
            String other$tokenUri = other.getTokenUri();
            if (this$tokenUri == null ? other$tokenUri != null : !this$tokenUri.equals(other$tokenUri)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
                return false;
            }
            String this$scopes = this.getScopes();
            String other$scopes = other.getScopes();
            if (this$scopes == null ? other$scopes != null : !this$scopes.equals(other$scopes)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            Set<String> this$actions = this.getActions();
            Set<String> other$actions = other.getActions();
            if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
                return false;
            }
            String this$audience = this.getAudience();
            String other$audience = other.getAudience();
            if (this$audience == null ? other$audience != null : !this$audience.equals(other$audience)) {
                return false;
            }
            List<String> this$tokenIssuersUris = this.getTokenIssuersUris();
            List<String> other$tokenIssuersUris = other.getTokenIssuersUris();
            if (this$tokenIssuersUris == null ? other$tokenIssuersUris != null : !((Object)this$tokenIssuersUris).equals(other$tokenIssuersUris)) {
                return false;
            }
            String this$policyEvaluationRequester = this.getPolicyEvaluationRequester();
            String other$policyEvaluationRequester = other.getPolicyEvaluationRequester();
            if (this$policyEvaluationRequester == null ? other$policyEvaluationRequester != null : !this$policyEvaluationRequester.equals(other$policyEvaluationRequester)) {
                return false;
            }
            String this$policyEvaluationUri = this.getPolicyEvaluationUri();
            String other$policyEvaluationUri = other.getPolicyEvaluationUri();
            return !(this$policyEvaluationUri == null ? other$policyEvaluationUri != null : !this$policyEvaluationUri.equals(other$policyEvaluationUri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OAuthClient;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tokenUri = this.getTokenUri();
            result = result * 59 + ($tokenUri == null ? 43 : $tokenUri.hashCode());
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            String $scopes = this.getScopes();
            result = result * 59 + ($scopes == null ? 43 : $scopes.hashCode());
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            Set<String> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            String $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : $audience.hashCode());
            List<String> $tokenIssuersUris = this.getTokenIssuersUris();
            result = result * 59 + ($tokenIssuersUris == null ? 43 : ((Object)$tokenIssuersUris).hashCode());
            String $policyEvaluationRequester = this.getPolicyEvaluationRequester();
            result = result * 59 + ($policyEvaluationRequester == null ? 43 : $policyEvaluationRequester.hashCode());
            String $policyEvaluationUri = this.getPolicyEvaluationUri();
            result = result * 59 + ($policyEvaluationUri == null ? 43 : $policyEvaluationUri.hashCode());
            return result;
        }

        public String toString() {
            return "AuditEventLoggerConfig.OAuthClient(tokenUri=" + this.getTokenUri() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", scopes=" + this.getScopes() + ", resource=" + this.getResource() + ", actions=" + String.valueOf(this.getActions()) + ", audience=" + this.getAudience() + ", tokenIssuersUris=" + String.valueOf(this.getTokenIssuersUris()) + ", policyEvaluationRequester=" + this.getPolicyEvaluationRequester() + ", policyEvaluationUri=" + this.getPolicyEvaluationUri() + ")";
        }

        public OAuthClient() {
        }

        public OAuthClient(String tokenUri, String clientId, String clientSecret, String scopes, String resource, Set<String> actions, String audience, List<String> tokenIssuersUris, String policyEvaluationRequester, String policyEvaluationUri) {
            this.tokenUri = tokenUri;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.scopes = scopes;
            this.resource = resource;
            this.actions = actions;
            this.audience = audience;
            this.tokenIssuersUris = tokenIssuersUris;
            this.policyEvaluationRequester = policyEvaluationRequester;
            this.policyEvaluationUri = policyEvaluationUri;
        }
    }
}

