/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth;

import com.dnastack.auth.cache.CachingConcurrentHashMap;
import com.dnastack.auth.client.TokenActionsClient;
import com.dnastack.auth.model.IssuerInfo;
import com.dnastack.auth.model.TokenActions;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JwtTokenParser {
    private static final long EXPIRE_CACHE_AFTER = 43200000L;
    private final JwtParser jwtParser;
    private final Collection<IssuerInfo> allowedIssuers;
    private final TokenActionsClient tokenActionsClient;
    private final Map<String, TokenActions> tokenActionsCache;

    public JwtTokenParser(JwtParser jwtParser, Collection<IssuerInfo> allowedIssuers, TokenActionsClient tokenActionsClient) {
        this.jwtParser = jwtParser;
        this.allowedIssuers = allowedIssuers;
        this.tokenActionsClient = tokenActionsClient;
        this.tokenActionsCache = new CachingConcurrentHashMap<String, TokenActions>(43200000L, 10000L, value -> value.getExpiresAt() != null && Instant.now().isBefore(value.getExpiresAt()));
    }

    public Collection<IssuerInfo> getAllowedIssuers() {
        return this.allowedIssuers;
    }

    public Jws<Claims> parseTokenClaims(String jwtToken) {
        return Optional.ofNullable(this.jwtParser.parseSignedClaims((CharSequence)jwtToken)).orElseThrow(() -> new JwtException("No claims specified in token."));
    }

    public String parseTokenJti(Jws<Claims> jwsClaims) {
        return Optional.ofNullable(jwsClaims).map(Jwt::getPayload).map(Claims::getId).orElseThrow(() -> new JwtException("No jti specieid in token."));
    }

    public Date parseTokenExpiration(Jws<Claims> jwsClaims) {
        return Optional.ofNullable(jwsClaims).map(Jwt::getPayload).map(Claims::getExpiration).orElseThrow(() -> new JwtException("No exp claim specified in token."));
    }

    public Collection<String> parseTokenAudiences(Jws<Claims> jwsClaims) {
        return Optional.ofNullable(jwsClaims).map(Jwt::getPayload).map(claims -> claims.get("aud", Object.class)).map(audienceClaim -> {
            Set<String> set;
            if (audienceClaim instanceof String) {
                String audClaim = (String)audienceClaim;
                set = Set.of(audClaim);
            } else {
                set = ((Collection)audienceClaim).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toSet());
            }
            return set;
        }).orElseThrow(() -> new JwtException("No aud claim specified in token."));
    }

    public String parseTokenIssuer(Jws<Claims> jwsClaims) {
        return Optional.ofNullable(jwsClaims).map(Jwt::getPayload).map(Claims::getIssuer).orElseThrow(() -> new JwtException("No iss claim specified in token."));
    }

    public List<String> parseTokenScopes(Jws<Claims> jwsClaims) {
        return Optional.ofNullable(jwsClaims).map(Jwt::getPayload).map(claims -> (String)claims.get("scope", String.class)).map(scopeClaim -> List.of(scopeClaim.split(" "))).orElseThrow(() -> new JwtException("No scope claim specified in token."));
    }

    public Map<String, Set<String>> parseTokenActions(Jws<Claims> jwsClaims) {
        return Optional.ofNullable(jwsClaims).map(Jwt::getPayload).map(claims -> {
            Object actionsClaim = claims.get("actions", Object.class);
            if (actionsClaim instanceof Map) {
                Map parsedActions = (Map)actionsClaim;
                Map<String, Set> result = parsedActions.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> new HashSet((Collection)entry.getValue())));
                return result;
            }
            return this.tokenActionsCache.computeIfAbsent(actionsClaim.toString(), key -> {
                TokenActions tokenActions = this.tokenActionsClient.getTokenActions((String)key);
                tokenActions.setExpiresAt(Instant.ofEpochSecond((Long)claims.get("exp", Long.class)));
                return tokenActions;
            }).getActions();
        }).orElseThrow(() -> new JwtException("No actions claim specified in token."));
    }
}

