/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth;

import com.dnastack.auth.JwtTokenParser;
import com.dnastack.auth.JwtTokenParserFactory;
import com.dnastack.auth.client.TokenActionsClient;
import com.dnastack.auth.model.IssuerInfo;
import com.dnastack.auth.model.JwtTokenParsers;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JwtTokenParsersFactory {
    private JwtTokenParsersFactory() {
    }

    public static JwtTokenParsers create(Collection<IssuerInfo> allowedIssuers, TokenActionsClient tokenActionsClient) {
        JwtTokenParser globalJwtTokenParser = JwtTokenParserFactory.create(JwtTokenParsersFactory.createIssuerInfoForAllIssuersAndAudiences(allowedIssuers), tokenActionsClient);
        JwtTokenParser defaultJwtTokenParser = JwtTokenParserFactory.create(JwtTokenParsersFactory.getResourceNonspecificIssuerInfo(allowedIssuers), tokenActionsClient);
        Map<String, JwtTokenParser> jwtTokenParserByResource = JwtTokenParsersFactory.getIssuerInfoByResource(allowedIssuers).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JwtTokenParserFactory.create(List.of((IssuerInfo)entry.getValue()), tokenActionsClient)));
        return new JwtTokenParsers(globalJwtTokenParser, defaultJwtTokenParser, jwtTokenParserByResource);
    }

    private static Collection<IssuerInfo> createIssuerInfoForAllIssuersAndAudiences(Collection<IssuerInfo> allowedIssuers) {
        return allowedIssuers.stream().collect(Collectors.groupingBy(IssuerInfo::getIssuerUri)).values().stream().map(issuerInfoForIssuerUri -> {
            Set<String> allAudiencesForIssuer = issuerInfoForIssuerUri.stream().map(IssuerInfo::getAllowedAudiences).flatMap(Collection::stream).collect(Collectors.toSet());
            IssuerInfo issuerInfo = (IssuerInfo)issuerInfoForIssuerUri.stream().findFirst().orElseThrow(() -> new IllegalStateException("IssuerInfo not found."));
            return new IssuerInfo(issuerInfo.getIssuerUri(), allAudiencesForIssuer, issuerInfo.getPublicKeyResolver());
        }).collect(Collectors.toList());
    }

    private static Collection<IssuerInfo> getResourceNonspecificIssuerInfo(Collection<IssuerInfo> allowedIssuers) {
        return allowedIssuers.stream().filter(issuerInfo -> {
            Collection<String> allowedResources = issuerInfo.getAllowedResources();
            return allowedResources == null || allowedResources.isEmpty();
        }).collect(Collectors.toList());
    }

    private static Collection<IssuerInfo> getResourceSpecificIssuerInfo(Collection<IssuerInfo> allowedIssuers) {
        return allowedIssuers.stream().filter(issuerInfo -> {
            Collection<String> allowedResources = issuerInfo.getAllowedResources();
            return allowedResources != null && !allowedResources.isEmpty();
        }).collect(Collectors.toList());
    }

    private static Map<String, IssuerInfo> getIssuerInfoByResource(Collection<IssuerInfo> allowedIssuers) {
        HashMap<String, IssuerInfo> issuerInfoByResource = new HashMap<String, IssuerInfo>();
        Collection<IssuerInfo> issuerInfoWithResources = JwtTokenParsersFactory.getResourceSpecificIssuerInfo(allowedIssuers);
        issuerInfoWithResources.forEach(issuerInfoWithResource -> issuerInfoWithResource.getAllowedResources().forEach(resource -> issuerInfoByResource.put((String)resource, (IssuerInfo)issuerInfoWithResource)));
        return issuerInfoByResource;
    }
}

