/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth;

import brave.Tracing;
import com.dnastack.auth.JwtTokenParsersFactory;
import com.dnastack.auth.PermissionChecker;
import com.dnastack.auth.TokenRevocationChecker;
import com.dnastack.auth.TokenRevocationHttpCheckerFactory;
import com.dnastack.auth.client.PolicyEvaluationClient;
import com.dnastack.auth.client.PolicyEvaluationHttpClientFactory;
import com.dnastack.auth.client.TokenActionsClient;
import com.dnastack.auth.client.TokenActionsHttpClientFactory;
import com.dnastack.auth.model.IssuerInfo;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import okhttp3.ConnectionPool;

public final class PermissionCheckerFactory {
    private static final long DEFAULT_EXPIRE_CACHE_AFTER = 43200000L;
    private static final long DEFAULT_FETCH_REVOCATION_LIST = 30000L;
    private static final long DEFAULT_FETCH_REVOKED_EVALUATIONS = 30000L;

    private PermissionCheckerFactory() {
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, String policyEvaluationUri, Tracing tracing) {
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, policyEvaluationUri, tracing, new ConnectionPool());
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, String policyEvaluationUri, Tracing tracing, ConnectionPool connectionPool) {
        if (Objects.isNull(policyEvaluationUri) || policyEvaluationUri.isBlank()) {
            throw new IllegalArgumentException("PolicyEvaluationUri could not be null or blank");
        }
        String tokenRevocationUri = URI.create(policyEvaluationUri).resolve("/tokens").toString();
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, policyEvaluationUri, tokenRevocationUri, 30000L, 43200000L, 30000L, tracing, connectionPool);
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, TokenRevocationChecker tokenRevocationChecker, TokenActionsClient tokenActionsClient, PolicyEvaluationClient policyEvaluationClient, Tracing tracing) {
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, tokenRevocationChecker, tokenActionsClient, policyEvaluationClient, 43200000L, 30000L, tracing);
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, String policyEvaluationUri, String tokenRevocationUri, Tracing tracing) {
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, policyEvaluationUri, tokenRevocationUri, 30000L, 43200000L, 30000L, tracing);
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, String policyEvaluationUri, String tokenRevocationUri, long fetchRevocationListIntervalMs, long expireCacheAfter, long fetchRevokedEvaluationsIntervalMs, Tracing tracing) {
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, policyEvaluationUri, tokenRevocationUri, fetchRevocationListIntervalMs, expireCacheAfter, fetchRevokedEvaluationsIntervalMs, tracing, new ConnectionPool());
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, String policyEvaluationUri, String tokenRevocationUri, long fetchRevocationListIntervalMs, long expireCacheAfter, long fetchRevokedEvaluationsIntervalMs, Tracing tracing, ConnectionPool connectionPool) {
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, TokenRevocationHttpCheckerFactory.create(tokenRevocationUri, fetchRevocationListIntervalMs, tracing, connectionPool), TokenActionsHttpClientFactory.create(tracing, connectionPool), PolicyEvaluationHttpClientFactory.create(policyEvaluationUri, tracing, connectionPool), expireCacheAfter, fetchRevokedEvaluationsIntervalMs, tracing);
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, String policyEvaluationUri, TokenRevocationChecker tokenRevocationChecker, long expireCacheAfter, long fetchRevokedEvaluationsIntervalMs, Tracing tracing) {
        ConnectionPool connectionPool = new ConnectionPool();
        return PermissionCheckerFactory.create(allowedIssuers, policyEvaluationRequester, tokenRevocationChecker, TokenActionsHttpClientFactory.create(tracing, connectionPool), PolicyEvaluationHttpClientFactory.create(policyEvaluationUri, tracing, connectionPool), expireCacheAfter, fetchRevokedEvaluationsIntervalMs, tracing);
    }

    public static PermissionChecker create(Collection<IssuerInfo> allowedIssuers, String policyEvaluationRequester, TokenRevocationChecker tokenRevocationChecker, TokenActionsClient tokenActionsClient, PolicyEvaluationClient policyEvaluationClient, long expireCacheAfter, long fetchRevokedEvaluationsIntervalMs, Tracing tracing) {
        PermissionCheckerFactory.checkIssuers(allowedIssuers);
        if (Objects.isNull(policyEvaluationRequester) || policyEvaluationRequester.isBlank()) {
            throw new IllegalArgumentException("policyEvaluationRequester could not be null or blank");
        }
        if (Objects.isNull(tokenRevocationChecker)) {
            throw new IllegalArgumentException("TokenRevocationChecker could not be null");
        }
        if (Objects.isNull(tokenActionsClient)) {
            throw new IllegalArgumentException("TokenActionsClient could not be null");
        }
        if (Objects.isNull(policyEvaluationClient)) {
            throw new IllegalArgumentException("PolicyEvaluationClient could not be null");
        }
        if (Objects.isNull(tracing)) {
            throw new IllegalArgumentException("Tracing could not be null");
        }
        return new PermissionChecker(JwtTokenParsersFactory.create(allowedIssuers, tokenActionsClient), tokenRevocationChecker, policyEvaluationRequester, policyEvaluationClient, expireCacheAfter, fetchRevokedEvaluationsIntervalMs);
    }

    private static void checkIssuers(Collection<IssuerInfo> allowedIssuers) {
        if (Objects.isNull(allowedIssuers) || allowedIssuers.isEmpty()) {
            throw new IllegalArgumentException("Argument allowedIssuers is required and cannot be null");
        }
        allowedIssuers.forEach(issuer -> {
            if (issuer.getAllowedAudiences() == null || issuer.getAllowedAudiences().isEmpty()) {
                throw new IllegalArgumentException(String.format("Allowed audiences for issuer [%s] is required and cannot be null or empty", issuer.getIssuerUri()));
            }
            if (issuer.getPublicKeyResolver() == null) {
                throw new IllegalArgumentException(String.format("Key supplier for issuer [%s] is required and cannot be null", issuer.getIssuerUri()));
            }
        });
    }
}

