/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth;

import brave.Tracing;
import com.dnastack.auth.TokenRevocationChecker;
import com.dnastack.auth.client.TokenRevocationFeignClient;
import com.dnastack.auth.client.TraceableHttpClientFactory;
import com.dnastack.auth.model.TokenRevocationList;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.ConnectionPool;

public class TokenRevocationHttpChecker
implements TokenRevocationChecker {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final long fetchRevocationListIntervalMs;
    private final TokenRevocationFeignClient tokenRevocationFeignClient;
    private final Map<String, Long> lastRevocationListUpdateForIssuer = new ConcurrentHashMap<String, Long>();
    private final Map<String, TokenRevocationList> revocationListForIssuer = new ConcurrentHashMap<String, TokenRevocationList>();
    private final String revocationUriPath;

    public TokenRevocationHttpChecker(String revocationUriPath, long fetchRevocationListIntervalMs, Tracing tracing) {
        this(revocationUriPath, fetchRevocationListIntervalMs, tracing, new ConnectionPool());
    }

    public TokenRevocationHttpChecker(String revocationUriPath, long fetchRevocationListIntervalMs, Tracing tracing, ConnectionPool pool) {
        this.tokenRevocationFeignClient = (TokenRevocationFeignClient)Feign.builder().client(TraceableHttpClientFactory.buildFeignClient(tracing, pool)).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).encoder((Encoder)new JacksonEncoder(DEFAULT_MAPPER)).decoder((Decoder)new JacksonDecoder(DEFAULT_MAPPER)).target(TokenRevocationFeignClient.class, "https://place-holder-uri.example.com/should/be/substitued/by/issuer/revocation/uri");
        this.fetchRevocationListIntervalMs = fetchRevocationListIntervalMs;
        this.revocationUriPath = revocationUriPath;
    }

    @Override
    public boolean isTokenRevoked(String jti, String issuerUri) {
        if (Objects.isNull(jti) || jti.isBlank()) {
            throw new IllegalArgumentException("Argument jti is required and cannot be null");
        }
        if (Objects.isNull(issuerUri) || issuerUri.isBlank()) {
            throw new IllegalArgumentException("Argument issuerUri is required and cannot be null");
        }
        this.maybeFetchOrUpdateRevocationList(issuerUri);
        TokenRevocationList revocationList = this.revocationListForIssuer.get(issuerUri);
        if (revocationList != null && revocationList.getTokens() != null) {
            return revocationList.getTokens().contains(jti);
        }
        return false;
    }

    public void updateRevocationList(String issuerUri) {
        this.lastRevocationListUpdateForIssuer.put(issuerUri, System.currentTimeMillis());
        this.revocationListForIssuer.put(issuerUri, this.tokenRevocationFeignClient.getRevocationList(URI.create(issuerUri).resolve(this.revocationUriPath)));
    }

    private void maybeFetchOrUpdateRevocationList(String issuerUri) {
        long now = System.currentTimeMillis();
        TokenRevocationList revocationList = this.revocationListForIssuer.get(issuerUri);
        Long lastRevocationListUpdate = this.lastRevocationListUpdateForIssuer.get(issuerUri);
        if (revocationList == null || lastRevocationListUpdate == null || lastRevocationListUpdate + this.fetchRevocationListIntervalMs < now) {
            this.updateRevocationList(issuerUri);
        }
    }
}

