/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.cache;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingConcurrentHashMap<K, V>
implements Map<K, V> {
    public static final long DEFAULT_TTL = 600000L;
    public static final long DEFAULT_MAX_SIZE = 10000L;
    private static final long CLEANUP_INTERVAL = 500L;
    private final ConcurrentHashMap<K, CacheEntry<V>> delegate;
    private final ConcurrentLinkedDeque<K> order;
    CacheEntryValidator<V> validator;
    private final long expireAfter;
    private final long maxSize;

    public CachingConcurrentHashMap(long expireAfterMs, long maxSize, CacheEntryValidator<V> validator) {
        if (expireAfterMs < 0L) {
            throw new IllegalArgumentException("Cache expireAfterMs cannot be negative");
        }
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("Cache maxSize cannot be negative");
        }
        this.delegate = new ConcurrentHashMap();
        this.order = new ConcurrentLinkedDeque();
        this.expireAfter = expireAfterMs;
        this.maxSize = maxSize;
        this.validator = validator != null ? validator : val -> true;
    }

    public CachingConcurrentHashMap(CacheEntryValidator<V> validator) {
        this(600000L, 10000L, validator);
    }

    public CachingConcurrentHashMap() {
        this(600000L, 10000L, null);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (CacheEntry<V> entry : this.delegate.values()) {
            if (!Objects.equals(value, entry.value) || !this.isValid(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        CacheEntry<V> entry = this.delegate.get(key);
        if (entry != null && !this.isValid(entry)) {
            this.remove(key);
            return null;
        }
        return this.extract(entry);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V old = null;
        if (this.delegate.containsKey(key)) {
            this.order.remove(key);
            old = this.extract(this.delegate.remove(key));
        }
        this.order.addLast(key);
        this.delegate.put(key, this.asEntry(value));
        this.cleanupExpiredEntries();
        this.maybeCrunch();
        return old;
    }

    @Override
    public V remove(Object key) {
        V old = this.extract(this.delegate.remove(key));
        if (old != null) {
            this.order.remove(key);
        }
        return old;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.order.clear();
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.delegate.values().stream().map(CacheEntry::getValue).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((CacheEntry)e.getValue()).getValue())).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    private V extract(CacheEntry<V> entry) {
        return entry == null ? null : (V)entry.getValue();
    }

    private CacheEntry<V> asEntry(V val) {
        return new CacheEntry<V>(val, this.getExpiry());
    }

    private long getExpiry() {
        return this.expireAfter + System.currentTimeMillis();
    }

    private void maybeCrunch() {
        K key;
        if ((long)this.delegate.size() > this.maxSize && (key = this.order.pop()) != null) {
            this.delegate.remove(key);
        }
    }

    private boolean isValid(CacheEntry<V> entry) {
        long validAfter = System.currentTimeMillis();
        return validAfter < entry.expiry && this.validator.isValid(entry.getValue());
    }

    private void cleanupExpiredEntries() {
        ArrayList deleteKeys = new ArrayList();
        long validAfter = System.currentTimeMillis();
        this.delegate.forEach((key, cacheEntry) -> {
            if (validAfter > cacheEntry.getExpiry() || !this.validator.isValid(cacheEntry.getValue())) {
                deleteKeys.add(key);
            }
        });
        deleteKeys.forEach(this.delegate::remove);
    }

    @FunctionalInterface
    public static interface CacheEntryValidator<V> {
        public boolean isValid(V var1);
    }

    static final class CacheEntry<K> {
        private final K value;
        private final long expiry;

        public CacheEntry(K value, long expiry) {
            this.value = value;
            this.expiry = expiry;
        }

        public K getValue() {
            return this.value;
        }

        public long getExpiry() {
            return this.expiry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheEntry)) {
                return false;
            }
            CacheEntry other = (CacheEntry)o;
            if (this.getExpiry() != other.getExpiry()) {
                return false;
            }
            K this$value = this.getValue();
            K other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expiry = this.getExpiry();
            result = result * 59 + (int)($expiry >>> 32 ^ $expiry);
            K $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "CachingConcurrentHashMap.CacheEntry(value=" + String.valueOf(this.getValue()) + ", expiry=" + this.getExpiry() + ")";
        }
    }
}

