/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.client;

import brave.Tracing;
import com.dnastack.auth.client.TraceableHttpClientFactory;
import com.dnastack.auth.exception.HttpRequestFailedException;
import com.dnastack.auth.model.Jwks;
import com.dnastack.auth.model.OidcConfiguration;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcHttpClient {
    private static final Logger log = LoggerFactory.getLogger(OidcHttpClient.class);
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;

    @Deprecated
    public OidcHttpClient() {
        log.warn("Creating an OidcHttpClient without a Tracer; access logs will not have trace or span IDs");
        this.objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.httpClient = new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)log).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BASIC)).build();
    }

    public OidcHttpClient(Tracing tracing, ConnectionPool connectionPool) {
        this.objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.httpClient = TraceableHttpClientFactory.buildOkHttpClient(tracing, connectionPool);
    }

    public OidcConfiguration getConfiguration(String issuerUri) {
        Request request = new Request.Builder().url(String.format("%s/.well-known/openid-configuration", issuerUri)).header("Accept", "application/json").get().build();
        return this.executeRequest(request, OidcConfiguration.class);
    }

    public Jwks getKeys(String jwksUri) {
        Request request = new Request.Builder().url(jwksUri).header("Accept", "application/json").get().build();
        return this.executeRequest(request, Jwks.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeRequest(Request request, Class<T> responseType) {
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.body() == null) {
                throw new IllegalStateException(String.format("Cannot read null body in response from request [%s %s]", request.method(), request.url()));
            }
            Reader bodyReader = response.body().charStream();
            Object object = this.objectMapper.readValue(bodyReader, responseType);
            return (T)object;
        }
        catch (IOException ex) {
            throw new HttpRequestFailedException(String.format("Failed request %s %s", request.method(), request.url()), ex);
        }
    }
}

