/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.client;

import brave.Tracing;
import com.dnastack.auth.client.PolicyEvaluationClient;
import com.dnastack.auth.client.PolicyEvaluationFeignClient;
import com.dnastack.auth.client.TraceableHttpClientFactory;
import com.dnastack.auth.model.Evaluation;
import com.dnastack.auth.model.EvaluationRequest;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.List;
import okhttp3.ConnectionPool;

public class PolicyEvaluationHttpClient
implements PolicyEvaluationClient {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final PolicyEvaluationFeignClient policyEvaluationFeignClient;

    @Deprecated
    public PolicyEvaluationHttpClient(String policyEvaluationUri, Tracing tracing) {
        this(policyEvaluationUri, tracing, new ConnectionPool());
    }

    public PolicyEvaluationHttpClient(String policyEvaluationUri, Tracing tracing, ConnectionPool pool) {
        this.policyEvaluationFeignClient = (PolicyEvaluationFeignClient)Feign.builder().client(TraceableHttpClientFactory.buildFeignClient(tracing, pool)).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).encoder((Encoder)new JacksonEncoder(DEFAULT_MAPPER)).decoder((Decoder)new JacksonDecoder(DEFAULT_MAPPER)).target(PolicyEvaluationFeignClient.class, policyEvaluationUri);
    }

    @Override
    public Evaluation getEvaluation(EvaluationRequest evaluationRequest) {
        return this.policyEvaluationFeignClient.sendEvaluationRequest(evaluationRequest);
    }

    @Override
    public List<String> getRevokedEvaluationsAfter(Long after) {
        return this.policyEvaluationFeignClient.getRevokedEvaluationsAfter(after);
    }
}

