/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class RetryOnSocketTimeoutInterceptor
implements Interceptor {
    private final int maxRetries;

    public RetryOnSocketTimeoutInterceptor() {
        this(3);
    }

    public RetryOnSocketTimeoutInterceptor(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        for (int retryCount = 0; retryCount < this.maxRetries; ++retryCount) {
            try {
                Response response = chain.proceed(request);
                return response;
            }
            catch (SocketTimeoutException exception) {
                continue;
            }
        }
        throw new IOException(String.format("Maximum number of retries (%d) after java.net.SocketTimeoutException reached. Last request was [%s] [%s] %s", this.maxRetries, request.method(), request.header("X-B3-TraceId"), request.url()));
    }
}

