/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.client;

import brave.Tracing;
import com.dnastack.auth.client.TokenActionsClient;
import com.dnastack.auth.client.TokenActionsFeignClient;
import com.dnastack.auth.client.TraceableHttpClientFactory;
import com.dnastack.auth.model.TokenActions;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.net.URI;
import okhttp3.ConnectionPool;

public class TokenActionsHttpClient
implements TokenActionsClient {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final TokenActionsFeignClient tokenActionsFeignClient;

    @Deprecated
    public TokenActionsHttpClient(Tracing tracing) {
        this(tracing, new ConnectionPool());
    }

    public TokenActionsHttpClient(Tracing tracing, ConnectionPool pool) {
        this.tokenActionsFeignClient = (TokenActionsFeignClient)Feign.builder().client(TraceableHttpClientFactory.buildFeignClient(tracing, pool)).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).encoder((Encoder)new JacksonEncoder(DEFAULT_MAPPER)).decoder((Decoder)new JacksonDecoder(DEFAULT_MAPPER)).target(TokenActionsFeignClient.class, "https://place-holder-uri.example.com/should/be/substitued/by/uri/from/token");
    }

    @Override
    public TokenActions getTokenActions(String uri) {
        return this.tokenActionsFeignClient.getTokenActions(URI.create(uri));
    }
}

