/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.client;

import brave.Tracing;
import brave.okhttp3.TracingInterceptor;
import com.dnastack.auth.client.RetryOnSocketTimeoutInterceptor;
import feign.Client;
import feign.okhttp.OkHttpClient;
import java.util.concurrent.ExecutorService;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceableHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(TraceableHttpClientFactory.class);

    public static OkHttpClient.Builder getOkHttpClientBuilder(Tracing tracing) {
        ExecutorService executorService = tracing.currentTraceContext().executorService(new Dispatcher().executorService());
        return new OkHttpClient.Builder().dispatcher(executorService != null ? new Dispatcher(executorService) : new Dispatcher()).addNetworkInterceptor(TracingInterceptor.create((Tracing)tracing));
    }

    @Deprecated
    public static okhttp3.OkHttpClient buildOkHttpClient(Tracing tracing) {
        return TraceableHttpClientFactory.getOkHttpClientBuilder(tracing).addNetworkInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)log).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BASIC)).build();
    }

    public static okhttp3.OkHttpClient buildOkHttpClient(Tracing tracing, ConnectionPool pool) {
        return TraceableHttpClientFactory.getOkHttpClientBuilder(tracing).connectionPool(pool).addNetworkInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)log).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BASIC)).addInterceptor((Interceptor)new RetryOnSocketTimeoutInterceptor()).build();
    }

    @Deprecated
    public static Client buildFeignClient(Tracing tracing) {
        return new OkHttpClient(TraceableHttpClientFactory.buildOkHttpClient(tracing));
    }

    public static Client buildFeignClient(Tracing tracing, ConnectionPool pool) {
        return new OkHttpClient(TraceableHttpClientFactory.buildOkHttpClient(tracing, pool));
    }
}

