/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.keyresolver;

import com.dnastack.auth.client.OidcHttpClient;
import com.dnastack.auth.keyresolver.IssuerPubKeyResolver;
import com.dnastack.auth.keyresolver.RsaKeyHelper;
import com.dnastack.auth.model.IssuerKeyIdPair;
import com.dnastack.auth.model.Jwks;
import com.dnastack.auth.model.OidcConfiguration;
import io.jsonwebtoken.JwtException;
import java.math.BigInteger;
import java.security.Key;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingIssuerPubKeyJwksResolver
implements IssuerPubKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(CachingIssuerPubKeyJwksResolver.class);
    private static final long DEFAULT_FETCH_JWKS_INTERVAL = 30000L;
    private final OidcHttpClient oidcHttpClient;
    private final String issuerUri;
    private final Map<String, Jwks.RsaJwk> keysByKidCache;
    private final long fetchJwksInterval;
    private long lastJwksFetchTime = 0L;

    public static CachingIssuerPubKeyJwksResolver create(String issuerUri, OidcHttpClient oidcHttpClient) {
        Objects.requireNonNull(oidcHttpClient, "OidcHttpClient must not be null");
        return new CachingIssuerPubKeyJwksResolver(issuerUri, oidcHttpClient);
    }

    public static CachingIssuerPubKeyJwksResolver create(String issuerUri, OidcHttpClient oidcHttpClient, long fetchJwksInterval) {
        Objects.requireNonNull(oidcHttpClient, "OidcHttpClient must not be null");
        return new CachingIssuerPubKeyJwksResolver(issuerUri, oidcHttpClient, fetchJwksInterval);
    }

    @Deprecated
    public CachingIssuerPubKeyJwksResolver(String issuerUri) {
        this(issuerUri, null);
    }

    @Deprecated
    public CachingIssuerPubKeyJwksResolver(String issuerUri, OidcHttpClient oidcHttpClient) {
        this(issuerUri, oidcHttpClient, 30000L);
    }

    @Deprecated
    public CachingIssuerPubKeyJwksResolver(String issuerUri, OidcHttpClient oidcHttpClient, long fetchJwksInterval) {
        Objects.requireNonNull(issuerUri, "Argument issuerUri must not be null");
        this.issuerUri = issuerUri;
        this.oidcHttpClient = Objects.isNull(oidcHttpClient) ? new OidcHttpClient() : oidcHttpClient;
        this.fetchJwksInterval = fetchJwksInterval;
        this.keysByKidCache = new ConcurrentHashMap<String, Jwks.RsaJwk>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key apply(IssuerKeyIdPair issuerKeyIdPair) {
        Jwks.RsaJwk foundJwk;
        String tokenIssuerUri = (String)issuerKeyIdPair.getKey();
        String tokenKeyId = (String)issuerKeyIdPair.getValue();
        if (!Objects.equals(tokenIssuerUri, this.issuerUri)) {
            throw new JwtException(String.format("Token from issuer [%s] does not match with the configured issuer [%s]", tokenIssuerUri, this.issuerUri));
        }
        CachingIssuerPubKeyJwksResolver cachingIssuerPubKeyJwksResolver = this;
        synchronized (cachingIssuerPubKeyJwksResolver) {
            long now = System.currentTimeMillis();
            if (this.lastJwksFetchTime + this.fetchJwksInterval < now || this.keysByKidCache.isEmpty() || tokenKeyId != null && !this.keysByKidCache.containsKey(tokenKeyId)) {
                this.updateJwksCache();
                this.lastJwksFetchTime = now;
            }
        }
        Jwks jwks = new Jwks(this.keysByKidCache.values().stream().collect(Collectors.toUnmodifiableList()));
        if (tokenKeyId != null) {
            foundJwk = jwks.getKeys().stream().filter(jwk -> Objects.equals(tokenKeyId, jwk.getKeyId())).findFirst().orElseThrow(() -> new JwtException(String.format("No key from issuer [%s] found for key ID [%s]", this.issuerUri, tokenKeyId)));
        } else if (jwks.getKeys().size() == 1) {
            foundJwk = jwks.getKeys().get(0);
        } else {
            throw new JwtException(String.format("Ambiguous key: token from issuer [%s] has no kid and JWKS endpoint contains multiple keys", this.issuerUri));
        }
        Base64.Decoder decoder = Base64.getUrlDecoder();
        BigInteger modulus = new BigInteger(1, decoder.decode(foundJwk.getModulus()));
        BigInteger publicExponent = new BigInteger(1, decoder.decode(foundJwk.getExponent()));
        return RsaKeyHelper.createPublicKey(modulus, publicExponent);
    }

    private void updateJwksCache() {
        try {
            log.debug("Updating Jwks cache");
            OidcConfiguration oidcConfiguration = this.oidcHttpClient.getConfiguration(this.issuerUri);
            Jwks jwks = this.oidcHttpClient.getKeys(oidcConfiguration.getJwksUri());
            this.keysByKidCache.clear();
            jwks.getKeys().forEach(rsaJwk -> this.keysByKidCache.put(rsaJwk.getKeyId(), (Jwks.RsaJwk)rsaJwk));
        }
        catch (RuntimeException e) {
            log.warn("Jwks cache update failed", (Throwable)e);
        }
    }
}

