/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.keyresolver;

import com.dnastack.auth.client.OidcHttpClient;
import com.dnastack.auth.keyresolver.IssuerPubKeyResolver;
import com.dnastack.auth.keyresolver.RsaKeyHelper;
import com.dnastack.auth.model.IssuerKeyIdPair;
import com.dnastack.auth.model.Jwks;
import com.dnastack.auth.model.OidcConfiguration;
import io.jsonwebtoken.JwtException;
import java.math.BigInteger;
import java.security.Key;
import java.util.Base64;
import java.util.Objects;

public class IssuerPubKeyJwksResolver
implements IssuerPubKeyResolver {
    private final OidcHttpClient oidcHttpClient;
    private final String issuerUri;

    public static IssuerPubKeyJwksResolver create(String issuerUri, OidcHttpClient oidcHttpClient) {
        Objects.requireNonNull(oidcHttpClient, "OidcHttpClient must not be null");
        return new IssuerPubKeyJwksResolver(issuerUri, oidcHttpClient);
    }

    @Deprecated
    public IssuerPubKeyJwksResolver(String issuerUri) {
        this(issuerUri, null);
    }

    @Deprecated
    public IssuerPubKeyJwksResolver(String issuerUri, OidcHttpClient oidcHttpClient) {
        Objects.requireNonNull(issuerUri, "Argument issuerUri must not be null");
        this.issuerUri = issuerUri;
        this.oidcHttpClient = Objects.isNull(oidcHttpClient) ? new OidcHttpClient() : oidcHttpClient;
    }

    @Override
    public Key apply(IssuerKeyIdPair issuerKeyIdPair) {
        Jwks.RsaJwk foundJwk;
        String tokenIssuerUri = (String)issuerKeyIdPair.getKey();
        String tokenKeyId = (String)issuerKeyIdPair.getValue();
        if (!Objects.equals(tokenIssuerUri, this.issuerUri)) {
            throw new JwtException(String.format("Token from issuer [%s] does not match with the configured issuer [%s]", tokenIssuerUri, this.issuerUri));
        }
        OidcConfiguration oidcConfiguration = this.oidcHttpClient.getConfiguration(this.issuerUri);
        Jwks jwks = this.oidcHttpClient.getKeys(oidcConfiguration.getJwksUri());
        if (tokenKeyId != null) {
            foundJwk = jwks.getKeys().stream().filter(jwk -> Objects.equals(tokenKeyId, jwk.getKeyId())).findFirst().orElseThrow(() -> new JwtException(String.format("No key from issuer [%s] found for key ID [%s]", this.issuerUri, tokenKeyId)));
        } else if (jwks.getKeys().size() == 1) {
            foundJwk = jwks.getKeys().get(0);
        } else {
            throw new JwtException(String.format("Ambiguous key: token from issuer [%s] has no kid and JWKS endpoint contains multiple keys", this.issuerUri));
        }
        Base64.Decoder decoder = Base64.getUrlDecoder();
        BigInteger modulus = new BigInteger(1, decoder.decode(foundJwk.getModulus()));
        BigInteger publicExponent = new BigInteger(1, decoder.decode(foundJwk.getExponent()));
        return RsaKeyHelper.createPublicKey(modulus, publicExponent);
    }
}

