/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.keyresolver;

import com.dnastack.auth.keyresolver.IssuerPubKeyResolver;
import com.dnastack.auth.keyresolver.RsaKeyHelper;
import com.dnastack.auth.model.IssuerKeyIdPair;
import io.jsonwebtoken.JwtException;
import java.security.Key;
import java.util.Objects;

public class IssuerPubKeyStaticResolver
implements IssuerPubKeyResolver {
    private final String issuerUri;
    private final Key key;

    public IssuerPubKeyStaticResolver(String issuerUri, Key key) {
        Objects.requireNonNull(issuerUri, "Argument issuerUri must not be null");
        Objects.requireNonNull(key, "Argument key must not be null");
        this.issuerUri = issuerUri;
        this.key = key;
    }

    public IssuerPubKeyStaticResolver(String issuerUri, String key) {
        Objects.requireNonNull(issuerUri, "Argument issuerUri must not be null");
        Objects.requireNonNull(key, "Argument key must not be null");
        this.issuerUri = issuerUri;
        this.key = RsaKeyHelper.parsePublicKey(key);
    }

    @Override
    public Key apply(IssuerKeyIdPair issuerKeyIdPair) {
        String tokenIssuerUri = (String)issuerKeyIdPair.getKey();
        if (!Objects.equals(tokenIssuerUri, this.issuerUri)) {
            throw new JwtException(String.format("Token from issuer [%s] does not match with the configured issuer [%s]", tokenIssuerUri, this.issuerUri));
        }
        return this.key;
    }
}

