/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.keyresolver;

import com.dnastack.auth.model.IssuerInfo;
import com.dnastack.auth.model.IssuerKeyIdPair;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import java.security.Key;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class JwksKeyResolver
extends SigningKeyResolverAdapter {
    private final Collection<IssuerInfo> allowedIssuers;

    public JwksKeyResolver(Collection<IssuerInfo> allowedIssuers) {
        Objects.requireNonNull(allowedIssuers, "Argument allowedIssuers must not be null");
        this.allowedIssuers = allowedIssuers;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        String issuerUri = claims.getIssuer();
        String keyId = header.getKeyId();
        IssuerInfo issuerInfo = this.allowedIssuers.stream().filter(allowedIssuer -> allowedIssuer.getIssuerUri().equals(issuerUri)).findFirst().orElseThrow(() -> new JwtException(String.format("Invalid issuer [%s], must be one of %s", issuerUri, this.getAllowedIssuersUris(this.allowedIssuers))));
        return issuerInfo.getPublicKeyResolver().apply(new IssuerKeyIdPair(issuerUri, keyId));
    }

    private List<String> getAllowedIssuersUris(Collection<IssuerInfo> allowedIssuers) {
        return allowedIssuers.stream().map(IssuerInfo::getIssuerUri).toList();
    }
}

