/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.keyresolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;

public class RsaKeyHelper {
    private static final Pattern SSH_PUB_KEY = Pattern.compile("ssh-(rsa|dsa) ([A-Za-z0-9/+]+=*) (.*)");
    private static final String BEGIN = "-----BEGIN";
    private static final Pattern PEM_DATA = Pattern.compile("-----BEGIN (.*)-----(.*)-----END (.*)-----", 32);

    public static java.security.interfaces.RSAPublicKey createPublicKey(BigInteger n, BigInteger e) {
        try {
            return (java.security.interfaces.RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(n, e));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static java.security.interfaces.RSAPublicKey parsePublicKey(String key) {
        Matcher m = SSH_PUB_KEY.matcher(key);
        if (m.matches()) {
            String alg = m.group(1);
            String encKey = m.group(2);
            if (!"rsa".equalsIgnoreCase(alg)) {
                throw new IllegalArgumentException("Only RSA is currently supported, but algorithm was " + alg);
            }
            return RsaKeyHelper.parseSSHPublicKey(encKey);
        }
        if (!key.startsWith(BEGIN)) {
            return RsaKeyHelper.parseSSHPublicKey(key);
        }
        KeyPair kp = RsaKeyHelper.parseKeyPair(key);
        if (kp.getPublic() == null) {
            throw new IllegalArgumentException("Key data does not contain a public key");
        }
        return (java.security.interfaces.RSAPublicKey)kp.getPublic();
    }

    private static java.security.interfaces.RSAPublicKey parseSSHPublicKey(String encKey) {
        byte[] PREFIX = new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97};
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(encKey.getBytes(StandardCharsets.UTF_8)));
        byte[] prefix = new byte[11];
        try {
            if (in.read(prefix) != 11 || !Arrays.equals(PREFIX, prefix)) {
                throw new IllegalArgumentException("SSH key prefix not found");
            }
            BigInteger e = new BigInteger(RsaKeyHelper.readBigInteger(in));
            BigInteger n = new BigInteger(RsaKeyHelper.readBigInteger(in));
            return RsaKeyHelper.createPublicKey(n, e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyPair parseKeyPair(String pemData) {
        Matcher m = PEM_DATA.matcher(pemData = pemData.trim().replaceAll("\\\\n", ""));
        if (!m.matches()) {
            throw new IllegalArgumentException("String is not PEM encoded data");
        }
        String type = m.group(1);
        byte[] content = Base64.getMimeDecoder().decode(m.group(2).getBytes(StandardCharsets.UTF_8));
        PrivateKey privateKey = null;
        try {
            PublicKey publicKey;
            KeyFactory fact = KeyFactory.getInstance("RSA");
            if (type.equals("RSA PRIVATE KEY")) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)content);
                if (seq.size() != 9) {
                    throw new IllegalArgumentException("Invalid RSA Private Key ASN1 sequence.");
                }
                RSAPrivateKey key = RSAPrivateKey.getInstance((Object)seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
                RSAPrivateCrtKeySpec privSpec = new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrime1(), key.getPrime2(), key.getExponent1(), key.getExponent2(), key.getCoefficient());
                publicKey = fact.generatePublic(pubSpec);
                privateKey = fact.generatePrivate(privSpec);
            } else if (type.equals("PRIVATE KEY")) {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(content);
                privateKey = fact.generatePrivate(keySpec);
                BigInteger modulus = ((RSAPrivateCrtKey)privateKey).getModulus();
                BigInteger exponent = ((RSAPrivateCrtKey)privateKey).getPublicExponent();
                RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
                publicKey = fact.generatePublic(publicKeySpec);
            } else if (type.equals("PUBLIC KEY")) {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(content);
                publicKey = fact.generatePublic(keySpec);
            } else if (type.equals("RSA PUBLIC KEY")) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)content);
                RSAPublicKey key = RSAPublicKey.getInstance((Object)seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
                publicKey = fact.generatePublic(pubSpec);
            } else {
                throw new IllegalArgumentException(type + " is not a supported format");
            }
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] readBigInteger(ByteArrayInputStream in) throws IOException {
        byte[] b = new byte[4];
        if (in.read(b) != 4) {
            throw new IOException("Expected length data as 4 bytes");
        }
        int l = b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
        if (in.read(b = new byte[l]) != l) {
            throw new IOException("Expected " + l + " key bytes");
        }
        return b;
    }
}

