/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.auth.model;

import com.dnastack.auth.keyresolver.IssuerPubKeyResolver;
import java.util.Collection;

public class IssuerInfo {
    private final String issuerUri;
    private final Collection<String> allowedAudiences;
    private final Collection<String> allowedResources;
    private final IssuerPubKeyResolver publicKeyResolver;

    public IssuerInfo(String issuerUri, Collection<String> allowedAudiences, Collection<String> allowedResources, IssuerPubKeyResolver publicKeyResolver) {
        this.issuerUri = issuerUri;
        this.allowedAudiences = allowedAudiences;
        this.allowedResources = allowedResources;
        this.publicKeyResolver = publicKeyResolver;
    }

    public IssuerInfo(String issuerUri, Collection<String> allowedAudiences, IssuerPubKeyResolver publicKeyResolver) {
        this.issuerUri = issuerUri;
        this.allowedAudiences = allowedAudiences;
        this.allowedResources = null;
        this.publicKeyResolver = publicKeyResolver;
    }

    public String getIssuerUri() {
        return this.issuerUri;
    }

    public Collection<String> getAllowedAudiences() {
        return this.allowedAudiences;
    }

    public Collection<String> getAllowedResources() {
        return this.allowedResources;
    }

    public IssuerPubKeyResolver getPublicKeyResolver() {
        return this.publicKeyResolver;
    }

    public String toString() {
        return "IssuerInfo{issuerUri='" + this.issuerUri + "', allowedAudiences=" + String.valueOf(this.allowedAudiences) + ", publicKeyResolver=" + String.valueOf(this.publicKeyResolver) + ", allowedResources=" + String.valueOf(this.allowedResources) + "}";
    }

    public static class IssuerInfoBuilder {
        private String issuerUri;
        private Collection<String> allowedAudiences;
        private Collection<String> allowedResources;
        private IssuerPubKeyResolver publicKeyResolver;

        public static IssuerInfoBuilder builder() {
            return new IssuerInfoBuilder();
        }

        public IssuerInfoBuilder issuerUri(String issuerUri) {
            this.issuerUri = issuerUri;
            return this;
        }

        public IssuerInfoBuilder allowedAudiences(Collection<String> allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            return this;
        }

        public IssuerInfoBuilder allowedResources(Collection<String> allowedResources) {
            this.allowedResources = allowedResources;
            return this;
        }

        public IssuerInfoBuilder publicKeyResolver(IssuerPubKeyResolver publicKeyResolver) {
            this.publicKeyResolver = publicKeyResolver;
            return this;
        }

        public IssuerInfo build() {
            return new IssuerInfo(this.issuerUri, this.allowedAudiences, this.allowedResources, this.publicKeyResolver);
        }
    }
}

