/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.aspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

public class AnnotationFinder {
    public static <T extends Annotation> T getAnnotationFromMethod(Class<T> annotation, Method method) {
        if (method.isAnnotationPresent(annotation)) {
            return method.getAnnotation(annotation);
        }
        if (method.getDeclaringClass().isAnnotationPresent(annotation)) {
            return method.getDeclaringClass().getAnnotation(annotation);
        }
        Package directPackage = method.getDeclaringClass().getPackage();
        String[] packageParts = directPackage.getName().split("\\.");
        for (int i = packageParts.length; i >= 0; --i) {
            String targetPackageName = Arrays.stream(packageParts).limit(i).collect(Collectors.joining("."));
            Package targetPackage = method.getDeclaringClass().getClassLoader().getDefinedPackage(targetPackageName);
            if (targetPackage == null || !targetPackage.isAnnotationPresent(annotation)) continue;
            return targetPackage.getAnnotation(annotation);
        }
        return null;
    }
}

