/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.aspect;

import com.dnastack.audit.logger.ControllerAuditLogger;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AuditEventLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AuditEventLogAspect.class);
    public static final String REQUEST_MAPPING_ANNOTATION_METHOD_POINTCUT = "execution(@org.springframework.web.bind.annotation.RequestMapping * *(..)) ||execution(@(@org.springframework.web.bind.annotation.RequestMapping *) * *(..))";
    public static final String REST_CONTROLLER_CLASS_POINTCUT = "@within(org.springframework.web.bind.annotation.RestController)";
    public static final String MVC_CONTROLLER_CLASS_POINTCUT = "@within(org.springframework.stereotype.Controller)";
    public static final String LEGACY_AUDIT_IGNORE_ANNOTATION_CLASS_EXCLUSION_POINTCUT = "!@within(com.dnastack.audit.aspect.AuditIgnore)";
    public static final String AUDIT_IGNORE_ANNOTATION_CLASS_EXCLUSION_POINTCUT = "!@within(com.dnastack.audit.util.AuditIgnore)";
    public static final String LEGACY_AUDIT_IGNORE_ANNOTATION_METHOD_EXCLUSION_POINTCUT = "!@annotation(com.dnastack.audit.aspect.AuditIgnore)";
    public static final String AUDIT_IGNORE_ANNOTATION_METHOD_EXCLUSION_POINTCUT = "!@annotation(com.dnastack.audit.util.AuditIgnore)";
    private final ControllerAuditLogger controllerAuditLogger;

    public AuditEventLogAspect(ControllerAuditLogger controllerAuditLogger) {
        this.controllerAuditLogger = controllerAuditLogger;
    }

    @Before(value="(restControllers() || mvcControllers()) && requestMappingAnnotations() && excludedControllers() && excludedMethods()")
    public void beforeController(JoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        String[] parameterNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
        Object[] args = joinPoint.getArgs();
        this.controllerAuditLogger.beforeController(method, parameterNames, args);
    }

    @AfterReturning(value="(restControllers() || mvcControllers()) && requestMappingAnnotations() && excludedControllers() && excludedMethods()", returning="returnValue")
    public void afterController(JoinPoint joinPoint, Object returnValue) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object[] args = joinPoint.getArgs();
        this.controllerAuditLogger.afterController(method, args, returnValue);
    }

    @AfterThrowing(pointcut="(restControllers() || mvcControllers()) && requestMappingAnnotations() && excludedControllers() && excludedMethods()", throwing="exception", argNames="joinPoint,exception")
    public void afterException(JoinPoint joinPoint, Exception exception) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object[] args = joinPoint.getArgs();
        this.controllerAuditLogger.afterException(exception, method, args);
    }

    @Pointcut(value="execution(@org.springframework.web.bind.annotation.RequestMapping * *(..)) ||execution(@(@org.springframework.web.bind.annotation.RequestMapping *) * *(..))")
    public void requestMappingAnnotations() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    public void mvcControllers() {
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    public void restControllers() {
    }

    @Pointcut(value="!@within(com.dnastack.audit.aspect.AuditIgnore)")
    public void legacyExcludedControllers() {
    }

    @Pointcut(value="!@within(com.dnastack.audit.util.AuditIgnore)")
    public void newExcludedControllers() {
    }

    @Pointcut(value="legacyExcludedControllers() && newExcludedControllers()")
    public void excludedControllers() {
    }

    @Pointcut(value="!@annotation(com.dnastack.audit.aspect.AuditIgnore)")
    public void legacyExcludedMethods() {
    }

    @Pointcut(value="!@annotation(com.dnastack.audit.util.AuditIgnore)")
    public void newExcludedMethods() {
    }

    @Pointcut(value="legacyExcludedMethods() && newExcludedMethods()")
    public void excludedMethods() {
    }
}

