/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.config;

import brave.Tracer;
import brave.Tracing;
import com.dnastack.audit.aspect.AuditEventLogAspect;
import com.dnastack.audit.auth.AccessTokenDelegate;
import com.dnastack.audit.config.AuditEventLoggerProperties;
import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.emitter.EventsAuditEventBatchLogEmitter;
import com.dnastack.audit.emitter.EventsAuditEventLogEmitter;
import com.dnastack.audit.emitter.Slf4jAuditEventLogEmitter;
import com.dnastack.audit.logger.AuditEventLogger;
import com.dnastack.audit.logger.ControllerAuditLogger;
import com.dnastack.audit.service.AuditedPrincipalSupplier;
import com.dnastack.audit.service.ContextAwareEmittingAuditEventLogger;
import com.dnastack.audit.service.DefaultAuditedPrincipalSupplier;
import com.dnastack.audit.service.DisabledAuditEventLogger;
import com.dnastack.audit.util.AuditTracer;
import com.dnastack.audit.web.RequestAuditService;
import interceptor.TokenDelegate;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.tracing.BraveAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.boot.task.ThreadPoolTaskSchedulerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.task.DelegatingSecurityContextAsyncTaskExecutor;

@EnableAsync
@EnableScheduling
@ComponentScan(basePackages={"com.dnastack.audit"})
@ConfigurationPropertiesScan(basePackages={"com.dnastack.audit.config"})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class AuditEventLoggerAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(AuditEventLoggerAutoConfiguration.class);

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true}")
    @ConditionalOnMissingBean(value={AuditedPrincipalSupplier.class})
    public AuditedPrincipalSupplier auditedPrincipalSupplier(AuditEventLoggerProperties properties) {
        this.logger.info("Configuring AuditedPrincipalSupplier");
        return new DefaultAuditedPrincipalSupplier(properties.getServiceClientId());
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true}")
    @ConditionalOnMissingBean(value={AuditEventLogger.class})
    public AuditEventLogger auditEventLogger(AuditedPrincipalSupplier auditedPrincipalSupplier, List<AuditEventLogEmitter> auditEventLogEmitters, Tracer tracer) {
        this.logger.info("Configuring AuditEventLogger");
        return new ContextAwareEmittingAuditEventLogger(auditEventLogEmitters, auditedPrincipalSupplier, tracer);
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true}")
    public Slf4jAuditEventLogEmitter slf4jAuditEventLogEmitter(AuditEventLoggerProperties properties) {
        return new Slf4jAuditEventLogEmitter(properties.getJsonPrinterStyle());
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true} && (@environment.acceptsProfiles('audit-external') || ${auditing.publish-external:false})")
    @ConditionalOnMissingBean(value={TokenDelegate.class})
    public TokenDelegate tokenDelegate(AuditEventLoggerProperties properties, Tracing tracing) {
        this.logger.info("Configuring TokenDelegate");
        return new AccessTokenDelegate(properties.getOauthClient(), tracing);
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true} && (@environment.acceptsProfiles('audit-external') || ${auditing.publish-external:false}) && ${auditing.batch-processing-enabled:true}")
    public EventsAuditEventBatchLogEmitter eventsAuditEventBatchLogEmitter(AuditEventLoggerProperties properties, TokenDelegate tokenDelegate, AuditTracer auditTracer) {
        return new EventsAuditEventBatchLogEmitter(properties.getPublisher(), tokenDelegate, auditTracer);
    }

    @Bean
    @ConditionalOnExpression(value=" ${auditing.enabled:true} && (@environment.acceptsProfiles('audit-external') || ${auditing.publish-external:false}) && !${auditing.batch-processing-enabled:true}")
    public EventsAuditEventLogEmitter eventsAuditEventLogEmitter(AuditEventLoggerProperties properties, TokenDelegate tokenDelegate, AuditTracer auditTracer) {
        return new EventsAuditEventLogEmitter(properties.getPublisher(), tokenDelegate, auditTracer);
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true} && (@environment.acceptsProfiles('audit-external') || ${auditing.publish-external:false}) && ${auditing.batch-processing-enabled:true}")
    ThreadPoolTaskSchedulerCustomizer taskSchedulerCustomizer() {
        return taskScheduler -> {
            taskScheduler.setAwaitTerminationSeconds(30);
            taskScheduler.setWaitForTasksToCompleteOnShutdown(true);
        };
    }

    @Bean
    @ConditionalOnExpression(value="!${auditing.enabled:true}")
    public AuditEventLogger disabledAuditEventLogger() {
        return new DisabledAuditEventLogger();
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true}")
    public AuditEventLogAspect auditEventLogAspect(AuditEventLogger auditEventLogger, @Value(value="${app.url}") URI appUri, RequestAuditService requestAuditService, AuditTracer auditTracer) {
        return new AuditEventLogAspect(new ControllerAuditLogger(auditEventLogger, appUri, requestAuditService, auditTracer));
    }

    @Bean
    @ConditionalOnExpression(value="${auditing.enabled:true}")
    public TaskExecutor auditEventLoggingTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(8);
        executor.setMaxPoolSize(16);
        executor.setQueueCapacity(1000);
        executor.setThreadNamePrefix("AuditLogger-");
        executor.initialize();
        return new DelegatingSecurityContextAsyncTaskExecutor((AsyncTaskExecutor)executor);
    }

    @ConditionalOnExpression(value="(!@environment.acceptsProfiles('audit-external') && !${auditing.publish-external:false})")
    @Configuration
    @PropertySource(value={"classpath:audit-event-logger.properties"})
    @ConfigurationProperties(prefix="auditing")
    public static class DefaultAuditEventLoggerPropertes
    extends AuditEventLoggerProperties {
    }

    @ConditionalOnExpression(value="(@environment.acceptsProfiles('audit-external') || ${auditing.publish-external:false})")
    @PropertySource(value={"classpath:audit-event-logger-external.properties"})
    @Configuration
    @ConfigurationProperties(prefix="auditing")
    public static class ExternalAuditEventLoggerProperties
    extends AuditEventLoggerProperties {
    }
}

