/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.emitter;

import com.dnastack.audit.client.EventsClient;
import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.AuditEventBodyBatch;
import com.dnastack.audit.model.AuditEventLoggerConfig;
import com.dnastack.audit.util.AuditTracer;
import interceptor.TokenDelegate;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;

public class EventsAuditEventBatchLogEmitter
implements AuditEventLogEmitter {
    private static final Logger log = LoggerFactory.getLogger(EventsAuditEventBatchLogEmitter.class);
    private final EventsClient eventsClient;
    private final List<AuditEventBody> events = new ArrayList<AuditEventBody>();

    public EventsAuditEventBatchLogEmitter(AuditEventLoggerConfig.Publisher publisherConfig, TokenDelegate tokenDelegate, AuditTracer auditTracer) {
        this(new EventsClient(publisherConfig, tokenDelegate, auditTracer));
    }

    public EventsAuditEventBatchLogEmitter(EventsClient eventsClient) {
        Objects.requireNonNull(eventsClient, "eventsHttpClient must not be null");
        this.eventsClient = eventsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Scheduled(cron="${auditing.scheduling.batch-emit.cron}")
    public void emitBatch() {
        if (!this.events.isEmpty()) {
            ArrayList<AuditEventBody> batch;
            List<AuditEventBody> list = this.events;
            synchronized (list) {
                batch = new ArrayList<AuditEventBody>(this.events);
                this.events.removeAll(batch);
            }
            this.eventsClient.publishBatch(AuditEventBodyBatch.builder().events(batch).build());
        }
    }

    public void emit(AuditEventBody auditEvent) {
        this.events.add(auditEvent);
    }

    @PreDestroy
    public void emitBatchBeforeShutdown() {
        if (!this.events.isEmpty()) {
            this.eventsClient.publishBatch(AuditEventBodyBatch.builder().events(this.events).build());
        }
    }
}

