/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.logger;

import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.aspect.AnnotationFinder;
import com.dnastack.audit.aspect.AuditActionUri;
import com.dnastack.audit.aspect.AuditEventContextHolder;
import com.dnastack.audit.aspect.AuditEventCustomize;
import com.dnastack.audit.aspect.AuditEventCustomizer;
import com.dnastack.audit.aspect.AuditIgnoreHeaders;
import com.dnastack.audit.diff.JsonPatchDiffProvider;
import com.dnastack.audit.logger.AuditEventLogger;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.AuditEventOutcome;
import com.dnastack.audit.model.AuditedAction;
import com.dnastack.audit.model.AuditedContext;
import com.dnastack.audit.model.AuditedOutcome;
import com.dnastack.audit.model.AuditedResource;
import com.dnastack.audit.util.AuditTracer;
import com.dnastack.audit.web.RequestAuditService;
import com.dnastack.audit.web.RequestHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;

public class ControllerAuditLogger {
    private static final Logger log = LoggerFactory.getLogger(ControllerAuditLogger.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.create();
    private final AuditEventLogger auditEventLogger;
    private final URI appUri;
    private final RequestAuditService requestAuditService;
    private final AuditTracer auditTracer;

    public void beforeController(Method method, String[] parameterNames, Object[] args) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        arguments.put("request_headers", this.filterAuditIgnoreHeaders(method, this.requestAuditService.getHeaders(servletRequestAttributes.getRequest())));
        arguments.put("request_cookies", this.requestAuditService.getCookies(servletRequestAttributes.getRequest()));
        this.addMethodParametersToArgumentMap(arguments, method, parameterNames, args);
        String actionUri = this.getActionUri(method);
        AuditEventContextHolder.setAuditEvent(this.getBaseAuditEvent(servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse(), actionUri, this.appUri).build());
        AuditEventContextHolder.getAuditEvent().setOutcome(AuditedOutcome.builder().operationState(AuditEventOutcome.STARTED).build());
        AuditEventContextHolder.getAuditEvent().setExtraArguments(arguments);
        AuditEventCustomize auditEventCustomize = AnnotationFinder.getAnnotationFromMethod(AuditEventCustomize.class, method);
        if (auditEventCustomize != null) {
            AuditEventCustomizer customizer = this.getCusomizerInstance(auditEventCustomize.value());
            AuditEventContextHolder.setAuditEvent(customizer.beforeController(AuditEventContextHolder.getAuditEvent(), method.getParameters(), args));
        }
        this.logAuditEvent(AuditEventContextHolder.getAuditEvent());
        AuditEventContextHolder.setAuditEvent(this.getBaseAuditEvent(servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse(), actionUri, this.appUri).build());
    }

    public void afterController(Method method, Object[] args, Object returnValue) {
        AuditedContext auditedContext;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        assert (servletRequestAttributes.getResponse() != null);
        arguments.put("request_headers", this.filterAuditIgnoreHeaders(method, this.requestAuditService.getHeaders(servletRequestAttributes.getRequest())));
        arguments.put("response_headers", this.filterAuditIgnoreHeaders(method, this.requestAuditService.getHeaders(servletRequestAttributes.getResponse())));
        Map auditEventBodyExtraArguments = AuditEventContextHolder.getAuditEvent().getExtraArguments();
        if (auditEventBodyExtraArguments != null && !auditEventBodyExtraArguments.isEmpty()) {
            arguments.putAll(auditEventBodyExtraArguments);
        }
        if ((auditedContext = AuditEventContextHolder.getAuditEvent().getContext()).getLogSubjectBeforeAction() != null && auditedContext.getLogSubjectAfterAction() != null) {
            arguments.put("diff", JsonPatchDiffProvider.getDiff((Object)auditedContext.getLogSubjectBeforeAction(), (Object)auditedContext.getLogSubjectAfterAction()));
        }
        if (ControllerAuditLogger.outcomeIsMissingOrDefault(AuditEventContextHolder.getAuditEvent().getOutcome())) {
            AuditEventContextHolder.getAuditEvent().setOutcome(AuditedOutcome.builder().operationState(AuditEventOutcome.COMPLETED).build());
        }
        AuditEventContextHolder.getAuditEvent().setExtraArguments(arguments);
        AuditEventCustomize auditEventCustomize = AnnotationFinder.getAnnotationFromMethod(AuditEventCustomize.class, method);
        if (auditEventCustomize != null) {
            AuditEventCustomizer customizer = this.getCusomizerInstance(auditEventCustomize.value());
            AuditEventContextHolder.setAuditEvent(customizer.afterController(AuditEventContextHolder.getAuditEvent(), method.getParameters(), args, returnValue));
        }
        this.logAuditEvent(AuditEventContextHolder.getAuditEvent());
        AuditEventContextHolder.resetAuditEvent();
    }

    private static boolean outcomeIsMissingOrDefault(AuditedOutcome outcome) {
        return outcome == null || outcome.getOperationState() == null || outcome.getOperationState().equals(AuditEventOutcome.STARTED.getValue());
    }

    public void afterException(Exception exception, Method method, Object[] args) {
        ServletRequestAttributes servletRequestAttributes;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        Map auditEventBodyExtraArguments = AuditEventContextHolder.getAuditEvent().getExtraArguments();
        if (auditEventBodyExtraArguments != null && !auditEventBodyExtraArguments.isEmpty()) {
            arguments.putAll(auditEventBodyExtraArguments);
        }
        if ((servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            arguments.put("request_headers", this.filterAuditIgnoreHeaders(method, this.requestAuditService.getHeaders(servletRequestAttributes.getRequest())));
        }
        arguments.put("failure_reason", exception.getMessage());
        AuditEventContextHolder.getAuditEvent().setOutcome(AuditedOutcome.builder().operationState(AuditEventOutcome.FAILED).build());
        AuditEventContextHolder.getAuditEvent().setExtraArguments(arguments);
        AuditEventCustomize auditEventCustomize = AnnotationFinder.getAnnotationFromMethod(AuditEventCustomize.class, method);
        if (auditEventCustomize != null) {
            AuditEventCustomizer customizer = this.getCusomizerInstance(auditEventCustomize.value());
            AuditEventContextHolder.setAuditEvent(customizer.onException(AuditEventContextHolder.getAuditEvent(), method.getParameters(), args, exception));
        }
        this.logAuditEvent(AuditEventContextHolder.getAuditEvent());
        AuditEventContextHolder.resetAuditEvent();
    }

    private AuditEventCustomizer getCusomizerInstance(Class<? extends AuditEventCustomizer> customizerClazz) {
        try {
            return customizerClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Could not instantiate instance of " + customizerClazz.getName() + ". Skipping event customization");
        }
        catch (Exception e) {
            log.error("Could not customize audit event with customizer " + customizerClazz.getName() + ". Skipping event customization", (Throwable)e);
        }
        return AuditEventCustomizer.NOOP_AUDIT_EVENT_CUSTOMIZER;
    }

    private void logAuditEvent(AuditEventBody auditEventBody) {
        try {
            this.auditEventLogger.log(auditEventBody);
        }
        catch (Exception ex) {
            log.error("Failed to log audit event", (Throwable)ex);
        }
    }

    private AuditEventBody.AuditEventBodyBuilder getBaseAuditEvent(HttpServletRequest request, HttpServletResponse response, String actionUri, URI appUri) {
        String resourceUri = UriComponentsBuilder.fromUriString((String)request.getRequestURL().toString()).host(appUri.getHost()).port(appUri.getPort()).scheme(appUri.getScheme()).build().toUriString();
        return AuditEventBody.builder().action(AuditedAction.builder().uri(actionUri != null ? actionUri : String.format("http:%s", request.getMethod().toLowerCase())).build()).resource(AuditedResource.builder().uri(resourceUri).build()).context(AuditedContext.builder().type("http_request").inboundIp(RequestHelper.getRemoteAddress(request)).traceId(this.auditTracer.currentTraceId()).spanId(this.auditTracer.currentSpanId()).build());
    }

    private Map<String, Collection<String>> filterAuditIgnoreHeaders(Method method, Map<String, Collection<String>> headers) {
        AuditIgnoreHeaders annotation = AnnotationFinder.getAnnotationFromMethod(AuditIgnoreHeaders.class, method);
        if (annotation != null) {
            HashMap<String, Collection<String>> headersToReturn = new HashMap<String, Collection<String>>();
            List headersToIgnore = Stream.of(annotation.value()).map(String::toLowerCase).collect(Collectors.toList());
            for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                Collection<String> value = entry.getValue();
                if (headersToIgnore.contains(key.toLowerCase())) {
                    if (!annotation.rewriteHeaderValues()) continue;
                    headersToReturn.put(key, List.of(annotation.rewriteCharSequence()));
                    continue;
                }
                headersToReturn.put(key, value);
            }
            return headersToReturn;
        }
        return headers;
    }

    private void addMethodParametersToArgumentMap(Map<String, Object> arguments, Method method, String[] parameterNames, Object[] parameterValues) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameterNames.length; ++i) {
            Optional<Object> auditedParameter = this.requestAuditService.getAuditedParameter(parameters[i], parameterValues[i]);
            if (!auditedParameter.isPresent()) continue;
            arguments.put(parameterNames[i], auditedParameter.get());
        }
    }

    private String getActionUri(Method method) {
        if (method.isAnnotationPresent(AuditActionUri.class)) {
            return method.getAnnotation(AuditActionUri.class).value();
        }
        return String.format("%s:%s", method.getDeclaringClass().getSimpleName(), method.getName());
    }

    public ControllerAuditLogger(AuditEventLogger auditEventLogger, URI appUri, RequestAuditService requestAuditService, AuditTracer auditTracer) {
        this.auditEventLogger = auditEventLogger;
        this.appUri = appUri;
        this.requestAuditService = requestAuditService;
        this.auditTracer = auditTracer;
    }
}

