/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.service;

import brave.Tracer;
import com.dnastack.audit.emitter.AuditEventLogEmitter;
import com.dnastack.audit.logger.EmittingAuditEventLogger;
import com.dnastack.audit.model.AuditEventBody;
import com.dnastack.audit.model.AuditedContext;
import com.dnastack.audit.model.AuditedPrincipal;
import com.dnastack.audit.service.AuditedPrincipalSupplier;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class ContextAwareEmittingAuditEventLogger
extends EmittingAuditEventLogger {
    private final AuditedPrincipalSupplier auditedPrincipalSupplier;
    private final Tracer tracer;

    public ContextAwareEmittingAuditEventLogger(List<AuditEventLogEmitter> emitters, AuditedPrincipalSupplier auditedPrincipalSupplier, Tracer tracer) {
        super(emitters);
        this.auditedPrincipalSupplier = auditedPrincipalSupplier;
        this.tracer = tracer;
    }

    public void log(AuditEventBody auditEvent) {
        AuditedContext defaultContext = this.defaultContext();
        if (auditEvent.getContext() == null) {
            auditEvent.setContext(defaultContext);
        } else {
            if (auditEvent.getContext().getSpanId() == null) {
                auditEvent.getContext().setSpanId(defaultContext.getSpanId());
            }
            if (auditEvent.getContext().getTraceId() == null) {
                auditEvent.getContext().setTraceId(defaultContext.getTraceId());
            }
        }
        if (auditEvent.getTimestamp() == null) {
            auditEvent.setTimestamp(Instant.now());
        }
        if (auditEvent.getPrincipal() == null) {
            auditEvent.setPrincipal((AuditedPrincipal)this.auditedPrincipalSupplier.get());
        }
        this.tracer.currentSpan().tag("actionUri", Optional.ofNullable(auditEvent.getAction()).flatMap(auditedAction -> Optional.ofNullable(auditedAction.getUri())).orElse("(undefined)")).tag("resourceUri", Optional.ofNullable(auditEvent.getResource()).flatMap(auditedResource -> Optional.ofNullable(auditedResource.getUri())).orElse("(undefined)"));
        super.log(auditEvent);
    }

    private AuditedContext defaultContext() {
        AuditedContext.AuditedContextBuilder builder = AuditedContext.builder();
        Optional.ofNullable(this.tracer.currentSpan()).ifPresent(span -> builder.traceId(span.context().traceIdString()).spanId(span.context().spanIdString()));
        return builder.build();
    }
}

