/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.service;

import com.dnastack.audit.model.AuditedPrincipal;
import com.dnastack.audit.service.AuditedPrincipalSupplier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class DefaultAuditedPrincipalSupplier
implements AuditedPrincipalSupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuditedPrincipalSupplier.class);
    private final String serviceClientId;

    public DefaultAuditedPrincipalSupplier(String serviceClientId) {
        this.serviceClientId = serviceClientId;
    }

    @Override
    public AuditedPrincipal get() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return AuditedPrincipal.builder().id(this.serviceClientId).type("service").build();
        }
        if (authentication instanceof AnonymousAuthenticationToken) {
            return AuditedPrincipal.builder().id("anonymous").type("user").actor(new AuditedPrincipal.Actor("service", this.serviceClientId)).build();
        }
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authentication;
            String azp = (String)jwtAuthenticationToken.getTokenAttributes().get("azp");
            return AuditedPrincipal.builder().id(jwtAuthenticationToken.getName()).type(Objects.equals(jwtAuthenticationToken.getName(), azp) ? "service" : "user").actor(new AuditedPrincipal.Actor("service", azp)).build();
        }
        return AuditedPrincipal.builder().id(authentication.getName()).type("unknown").build();
    }
}

