/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.web;

import com.dnastack.audit.ObjectMapperFactory;
import com.dnastack.audit.util.AuditIgnore;
import com.dnastack.audit.web.RequestSecretFilter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.github.resilience4j.core.StringUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class RequestAuditService {
    private static final String SECRET_STRIPPED_CHAR_SEQUENCE = "***";
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.create();
    private final RequestSecretFilter requestSecretFilter;

    @Autowired
    public RequestAuditService(RequestSecretFilter requestSecretFilter) {
        this.requestSecretFilter = requestSecretFilter;
    }

    public Map<String, Collection<String>> getHeaders(HttpServletRequest request) {
        return this.getHeaders(Collections.list(request.getHeaderNames()), headerName -> Collections.list(request.getHeaders(headerName)));
    }

    private Map<String, Collection<String>> getHeaders(Collection<String> headerNames, Function<String, Collection<String>> getHeaderByName) {
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        headerNames.forEach(headerName -> {
            Collection headerValues = (Collection)getHeaderByName.apply((String)headerName);
            if (headerName.equalsIgnoreCase("Authorization")) {
                List<String> authHeaderValue = headerValues.stream().map(this::stripSecretsFromAuthorizationHeader).toList();
                headers.put((String)headerName, (Collection<String>)authHeaderValue);
            } else if (headerName.equalsIgnoreCase("Cookie")) {
                headerValues.forEach(cookieHeaderValue -> {
                    String[] cookiesPairs = cookieHeaderValue.split(";");
                    List<String> cookieNamesWithStrippedPasswords = Arrays.stream(cookiesPairs).map(cookiePair -> cookiePair.trim().split("=")[0]).map(cookieName -> String.format("%s=%s", cookieName, SECRET_STRIPPED_CHAR_SEQUENCE)).toList();
                    headers.put((String)headerName, (Collection<String>)cookieNamesWithStrippedPasswords);
                });
            } else if (this.requestSecretFilter.isSecretHeader((String)headerName)) {
                List<String> authHeaderValues = headerValues.stream().map(v -> SECRET_STRIPPED_CHAR_SEQUENCE).toList();
                headers.put((String)headerName, (Collection<String>)authHeaderValues);
            } else {
                headers.put((String)headerName, headerValues);
            }
        });
        return headers;
    }

    public Map<String, String> getCookies(HttpServletRequest request) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (request.getCookies() != null && request.getCookies().length > 0) {
            Arrays.stream(request.getCookies()).forEach(cookie -> cookies.put(cookie.getName(), SECRET_STRIPPED_CHAR_SEQUENCE));
        }
        return cookies;
    }

    public Map<String, Collection<String>> getHeaders(HttpServletResponse response) {
        return this.getHeaders(response.getHeaderNames(), arg_0 -> ((HttpServletResponse)response).getHeaders(arg_0));
    }

    private String stripSecretsFromAuthorizationHeader(String authHeaderValue) {
        String[] authHeaderValueTokenized = authHeaderValue.split(" ");
        if (authHeaderValueTokenized.length > 1) {
            String authorizationType = authHeaderValueTokenized[0];
            return authorizationType + " ***";
        }
        return SECRET_STRIPPED_CHAR_SEQUENCE;
    }

    public Optional<Object> getAuditedParameter(Parameter parameter, Object value) {
        if (parameter == null || value == null || this.shouldIgnoreParameter(parameter) || value instanceof ServletRequest || value instanceof ServletResponse) {
            return Optional.empty();
        }
        if (this.isSecretParameter(parameter)) {
            return Optional.of(SECRET_STRIPPED_CHAR_SEQUENCE);
        }
        if (parameter.isAnnotationPresent(RequestBody.class)) {
            return Optional.of(this.getAuditedRequestBody(value));
        }
        return Optional.of(OBJECT_MAPPER.convertValue(value, Object.class));
    }

    public JsonNode getAuditedRequestBody(Object value) {
        JsonNode paramJson = (JsonNode)OBJECT_MAPPER.convertValue(value, JsonNode.class);
        this.censorSecrets(paramJson);
        return paramJson;
    }

    private void censorSecrets(JsonNode value) {
        block4: {
            block3: {
                if (!(value instanceof ObjectNode)) break block3;
                ObjectNode objectNode = (ObjectNode)value;
                Iterator fields = objectNode.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    if (this.requestSecretFilter.isSecretRequestParameter((String)field.getKey())) {
                        objectNode.set((String)field.getKey(), (JsonNode)TextNode.valueOf((String)SECRET_STRIPPED_CHAR_SEQUENCE));
                        continue;
                    }
                    this.censorSecrets((JsonNode)field.getValue());
                }
                break block4;
            }
            if (!(value instanceof ArrayNode)) break block4;
            ArrayNode arrayNode = (ArrayNode)value;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.censorSecrets(arrayNode.get(i));
            }
        }
    }

    private boolean shouldIgnoreParameter(Parameter parameter) {
        return parameter.isAnnotationPresent(com.dnastack.audit.aspect.AuditIgnore.class) || parameter.isAnnotationPresent(AuditIgnore.class);
    }

    public boolean isSecretParameter(Parameter parameter) {
        for (Annotation anno : parameter.getAnnotations()) {
            if (anno instanceof RequestParam) {
                RequestParam requestParam = (RequestParam)anno;
                String requestParamName = this.firstNonEmptyValue(requestParam.value(), requestParam.name(), parameter.getName());
                if (this.requestSecretFilter.isSecretRequestParameter(requestParamName)) {
                    return true;
                }
            }
            if (!(anno instanceof RequestHeader)) continue;
            RequestHeader requestHeader = (RequestHeader)anno;
            String requestHeaderName = this.firstNonEmptyValue(requestHeader.value(), requestHeader.name(), parameter.getName());
            if (!this.requestSecretFilter.isSecretHeader(requestHeaderName)) continue;
            return true;
        }
        return false;
    }

    private String firstNonEmptyValue(String ... args) {
        return Arrays.stream(args).filter(StringUtils::isNotEmpty).findFirst().orElseThrow();
    }
}

