/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class RequestHelper {
    public static final String SECRET_STRIPPED_CHAR_SEQUENCE = "***";
    private static final String[] HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "X-Real-IP", "X-Forward-For", "Forwarded"};

    public static String getRemoteAddress(HttpServletRequest request) {
        for (String header : HEADERS_TO_TRY) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getTraceId(HttpServletResponse response) {
        return response.getHeader("X-B3-TraceId");
    }

    public static String getSpanId(HttpServletResponse response) {
        return response.getHeader("X-B3-SpanId");
    }
}

