/*
 * Decompiled with CFR 0.152.
 */
package com.dnastack.audit.web;

import io.vavr.Predicates;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class RequestSecretFilter {
    private final Predicate<String> headerSecretPredicate;
    private final Predicate<String> requestParamSecretPredicate;
    private static final Pattern CREDENTIALS = Pattern.compile(".*credentials.*");

    @Bean
    @Qualifier(value="audit-header-secret-predicate")
    public static Predicate<String> builtInHeaderSecretPredicate() {
        return RequestSecretFilter.createBuiltInHeaderSecretPredicate();
    }

    @NotNull
    public static Predicate<String> createBuiltInHeaderSecretPredicate() {
        return "authorization"::equalsIgnoreCase;
    }

    @Bean
    @Qualifier(value="audit-request-param-secret-predicate")
    public static Predicate<String> builtInRequestParamSecretPredicate() {
        return RequestSecretFilter.createBuiltInRequestParamSecretPredicate();
    }

    @NotNull
    public static Predicate<String> createBuiltInRequestParamSecretPredicate() {
        return Predicates.anyOf((Predicate[])new Predicate[]{"password"::equalsIgnoreCase, "secret"::equalsIgnoreCase, "key"::equalsIgnoreCase, "token"::equalsIgnoreCase, v -> CREDENTIALS.matcher((CharSequence)v).matches(), "client_secret"::equalsIgnoreCase, "refresh_token"::equalsIgnoreCase, "subject_token"::equalsIgnoreCase, "client_assertion"::equalsIgnoreCase, "device_code"::equalsIgnoreCase});
    }

    @Autowired
    public RequestSecretFilter(@Qualifier(value="audit-header-secret-predicate") Collection<Predicate<String>> auditHeaderSecretPredicates, @Qualifier(value="audit-request-param-secret-predicate") Collection<Predicate<String>> auditRequestParamSecretPredicates) {
        Predicate[] a = new Predicate[]{};
        this.headerSecretPredicate = Predicates.anyOf((Predicate[])auditHeaderSecretPredicates.toArray(a));
        this.requestParamSecretPredicate = Predicates.anyOf((Predicate[])auditRequestParamSecretPredicates.toArray(a));
    }

    public RequestSecretFilter() {
        this(List.of(RequestSecretFilter.createBuiltInHeaderSecretPredicate()), List.of(RequestSecretFilter.createBuiltInRequestParamSecretPredicate()));
    }

    public boolean isSecretHeader(String headerName) {
        return this.headerSecretPredicate.test(headerName);
    }

    public boolean isSecretRequestParameter(String parameterName) {
        return this.requestParamSecretPredicate.test(parameterName);
    }
}

