/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IAggregatingConverter;
import com.documents4j.api.IConversionJobWithPriorityUnspecified;
import com.documents4j.api.IConversionJobWithSourceSpecified;
import com.documents4j.api.IConversionJobWithSourceUnspecified;
import com.documents4j.api.IConversionJobWithTargetUnspecified;
import com.documents4j.api.IConverter;
import com.documents4j.api.IConverterFailureCallback;
import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IFileSource;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.api.ISelectionStrategy;
import com.documents4j.job.FailureAwareConverter;
import com.documents4j.job.FileSourceFromFile;
import com.documents4j.job.ImpossibleConverter;
import com.documents4j.job.InputStreamSourceFromInputStream;
import com.documents4j.job.NoOpConverterFailureCallback;
import com.documents4j.job.NoopFileConsumer;
import com.documents4j.job.OutputStreamToInputStreamConsumer;
import com.documents4j.job.RoundRobinSelectionStrategy;
import com.documents4j.throwables.ConverterAccessException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatingConverter
implements IAggregatingConverter,
IConverterFailureCallback,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatingConverter.class);
    private final CopyOnWriteArrayList<IConverter> converters;
    private final ISelectionStrategy selectionStrategy;
    private final IConverterFailureCallback converterFailureCallback;
    private final boolean propagateShutDown;
    private volatile Future<?> selfCheck;

    protected AggregatingConverter(CopyOnWriteArrayList<IConverter> converters, ISelectionStrategy selectionStrategy, IConverterFailureCallback converterFailureCallback, boolean propagateShutDown) {
        this.converters = converters;
        this.selectionStrategy = selectionStrategy;
        this.converterFailureCallback = converterFailureCallback;
        this.propagateShutDown = propagateShutDown;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static IAggregatingConverter make(IConverter ... converters) {
        Preconditions.checkNotNull((Object)converters);
        return AggregatingConverter.make(Arrays.asList(converters));
    }

    public static IAggregatingConverter make(Collection<? extends IConverter> converters) {
        Preconditions.checkNotNull(converters);
        return AggregatingConverter.builder().aggregates(converters).build();
    }

    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        HashMap<DocumentType, Set<DocumentType>> supportedConversions = new HashMap<DocumentType, Set<DocumentType>>();
        for (IConverter converter : this.converters) {
            for (Map.Entry entry : converter.getSupportedConversions().entrySet()) {
                Set targetTypes = supportedConversions.computeIfAbsent((DocumentType)entry.getKey(), k -> new HashSet());
                targetTypes.addAll((Collection)entry.getValue());
            }
        }
        return supportedConversions;
    }

    public boolean isOperational() {
        for (IConverter converter : this.converters) {
            if (!converter.isOperational()) continue;
            return true;
        }
        return false;
    }

    protected IConverter nextConverter(DocumentType sourceFormat, DocumentType targetFormat) {
        ArrayList<IConverter> supportingConverters = new ArrayList<IConverter>(this.converters.size());
        for (IConverter converter : this.converters) {
            Set documentTypes = (Set)converter.getSupportedConversions().get(sourceFormat);
            if (documentTypes == null || !documentTypes.contains(targetFormat)) continue;
            supportingConverters.add(converter);
        }
        if (supportingConverters.isEmpty()) {
            LOGGER.trace("No converter available for conversion of {} to {}", (Object)sourceFormat, (Object)targetFormat);
            return new ImpossibleConverter();
        }
        IConverter converter = this.selectionStrategy.select(supportingConverters);
        LOGGER.trace("Selected {} for conversion of {} to {}", new Object[]{converter, sourceFormat, targetFormat});
        return new FailureAwareConverter(converter, this);
    }

    public IConversionJobWithSourceUnspecified convert(File source) {
        return this.convert((IFileSource)new FileSourceFromFile(source));
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source) {
        return this.convert(source, true);
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source, boolean close) {
        return this.convert((IInputStreamSource)new InputStreamSourceFromInputStream(source, close));
    }

    public IConversionJobWithSourceUnspecified convert(IFileSource source) {
        return new AggregatedFileSourceConversionWithSourceUnspecified(source);
    }

    public IConversionJobWithSourceUnspecified convert(IInputStreamSource source) {
        return new AggregatedInputStreamConversionWithSourceUnspecified(source);
    }

    @Override
    public boolean register(IConverter converter) {
        if (this.converters.addIfAbsent(converter)) {
            LOGGER.info("Registered converter {} with {}", (Object)converter, (Object)this);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(IConverter converter) {
        if (this.converters.remove(converter)) {
            LOGGER.info("Removed converter {} from {}", (Object)converter, (Object)this);
            return true;
        }
        return false;
    }

    @Override
    public Set<IConverter> getConverters() {
        return new HashSet<IConverter>(this.converters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        if (this.selfCheck != null) {
            this.selfCheck.cancel(true);
        }
        try {
            if (this.propagateShutDown) {
                ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
                for (IConverter converter : this.converters) {
                    try {
                        converter.shutDown();
                    }
                    catch (RuntimeException e) {
                        exceptions.add(e);
                    }
                }
                if (!exceptions.isEmpty()) {
                    throw new ConverterAccessException("Shutting down aggregated converters caused at least one exception", (Throwable)exceptions.get(0));
                }
            }
        }
        finally {
            this.converters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        if (this.selfCheck != null) {
            this.selfCheck.cancel(true);
        }
        try {
            if (this.propagateShutDown) {
                ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
                for (IConverter converter : this.converters) {
                    try {
                        converter.kill();
                    }
                    catch (RuntimeException e) {
                        exceptions.add(e);
                    }
                }
                if (!exceptions.isEmpty()) {
                    throw new ConverterAccessException("Shutting down aggregated converters caused at least one exception", (Throwable)exceptions.get(0));
                }
            }
        }
        finally {
            this.converters.clear();
        }
    }

    @Override
    public void onFailure(IConverter converter) {
        if (this.converters.remove(converter)) {
            try {
                converter.shutDown();
            }
            catch (RuntimeException exception) {
                LOGGER.error("Could not shut down {}", (Object)converter, (Object)exception);
            }
            finally {
                this.converterFailureCallback.onFailure(converter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (IConverter converter : this.converters) {
            if (converter.isOperational() || !this.converters.remove(converter)) continue;
            try {
                converter.shutDown();
            }
            catch (RuntimeException e) {
                LOGGER.warn("Could not shut down {} during deregistration", (Object)converter, (Object)e);
            }
            finally {
                this.converterFailureCallback.onFailure(converter);
            }
        }
    }

    private class AggregatedInputStreamSourceToInputStreamConsumerConversionWithSourceSpecified
    implements IConversionJobWithTargetUnspecified {
        private final IInputStreamSource source;
        private final DocumentType sourceFormat;
        private final IInputStreamConsumer callback;

        private AggregatedInputStreamSourceToInputStreamConsumerConversionWithSourceSpecified(IInputStreamSource source, DocumentType sourceFormat, IInputStreamConsumer callback) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.callback = callback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return AggregatingConverter.this.nextConverter(this.sourceFormat, targetFormat).convert(this.source).as(this.sourceFormat).to(this.callback).as(targetFormat);
        }
    }

    private class AggregatedInputStreamSourceToFileConsumerConversionWithSourceSpecified
    implements IConversionJobWithTargetUnspecified {
        private final IInputStreamSource source;
        private final DocumentType sourceFormat;
        private final File target;
        private final IFileConsumer callback;

        private AggregatedInputStreamSourceToFileConsumerConversionWithSourceSpecified(IInputStreamSource source, DocumentType sourceFormat, File target, IFileConsumer callback) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.target = target;
            this.callback = callback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return AggregatingConverter.this.nextConverter(this.sourceFormat, targetFormat).convert(this.source).as(this.sourceFormat).to(this.target, this.callback).as(targetFormat);
        }
    }

    private class AggregatedInputStreamSourceConversionWithSourceSpecified
    implements IConversionJobWithSourceSpecified {
        private final IInputStreamSource source;
        private final DocumentType sourceFormat;

        private AggregatedInputStreamSourceConversionWithSourceSpecified(IInputStreamSource source, DocumentType sourceFormat) {
            this.source = source;
            this.sourceFormat = sourceFormat;
        }

        public IConversionJobWithTargetUnspecified to(File target) {
            return this.to(target, (IFileConsumer)new NoopFileConsumer());
        }

        public IConversionJobWithTargetUnspecified to(File target, IFileConsumer callback) {
            return new AggregatedInputStreamSourceToFileConsumerConversionWithSourceSpecified(this.source, this.sourceFormat, target, callback);
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target) {
            return this.to(target, true);
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target, boolean closeStream) {
            return this.to((IInputStreamConsumer)new OutputStreamToInputStreamConsumer(target, closeStream));
        }

        public IConversionJobWithTargetUnspecified to(IInputStreamConsumer callback) {
            return new AggregatedInputStreamSourceToInputStreamConsumerConversionWithSourceSpecified(this.source, this.sourceFormat, callback);
        }
    }

    private class AggregatedInputStreamConversionWithSourceUnspecified
    implements IConversionJobWithSourceUnspecified {
        private final IInputStreamSource source;

        public AggregatedInputStreamConversionWithSourceUnspecified(IInputStreamSource source) {
            this.source = source;
        }

        public IConversionJobWithSourceSpecified as(DocumentType sourceFormat) {
            return new AggregatedInputStreamSourceConversionWithSourceSpecified(this.source, sourceFormat);
        }
    }

    private class AggregatedFileSourceToInputStreamConsumerConversionWithSourceSpecified
    implements IConversionJobWithTargetUnspecified {
        private final IFileSource source;
        private final DocumentType sourceFormat;
        private final IInputStreamConsumer callback;

        private AggregatedFileSourceToInputStreamConsumerConversionWithSourceSpecified(IFileSource source, DocumentType sourceFormat, IInputStreamConsumer callback) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.callback = callback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return AggregatingConverter.this.nextConverter(this.sourceFormat, targetFormat).convert(this.source).as(this.sourceFormat).to(this.callback).as(targetFormat);
        }
    }

    private class AggregatedFileSourceToFileConsumerConversionWithSourceSpecified
    implements IConversionJobWithTargetUnspecified {
        private final IFileSource source;
        private final DocumentType sourceFormat;
        private final File target;
        private final IFileConsumer callback;

        private AggregatedFileSourceToFileConsumerConversionWithSourceSpecified(IFileSource source, DocumentType sourceFormat, File target, IFileConsumer callback) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.target = target;
            this.callback = callback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return AggregatingConverter.this.nextConverter(this.sourceFormat, targetFormat).convert(this.source).as(this.sourceFormat).to(this.target, this.callback).as(targetFormat);
        }
    }

    private class AggregatedFileSourceConversionWithSourceSpecified
    implements IConversionJobWithSourceSpecified {
        private final IFileSource source;
        private final DocumentType sourceFormat;

        private AggregatedFileSourceConversionWithSourceSpecified(IFileSource source, DocumentType sourceFormat) {
            this.source = source;
            this.sourceFormat = sourceFormat;
        }

        public IConversionJobWithTargetUnspecified to(File target) {
            return this.to(target, (IFileConsumer)new NoopFileConsumer());
        }

        public IConversionJobWithTargetUnspecified to(File target, IFileConsumer callback) {
            return new AggregatedFileSourceToFileConsumerConversionWithSourceSpecified(this.source, this.sourceFormat, target, callback);
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target) {
            return this.to(target, true);
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target, boolean closeStream) {
            return this.to((IInputStreamConsumer)new OutputStreamToInputStreamConsumer(target, closeStream));
        }

        public IConversionJobWithTargetUnspecified to(IInputStreamConsumer callback) {
            return new AggregatedFileSourceToInputStreamConsumerConversionWithSourceSpecified(this.source, this.sourceFormat, callback);
        }
    }

    private class AggregatedFileSourceConversionWithSourceUnspecified
    implements IConversionJobWithSourceUnspecified {
        private final IFileSource source;

        private AggregatedFileSourceConversionWithSourceUnspecified(IFileSource source) {
            this.source = source;
        }

        public IConversionJobWithSourceSpecified as(DocumentType sourceFormat) {
            return new AggregatedFileSourceConversionWithSourceSpecified(this.source, sourceFormat);
        }
    }

    public static class Builder {
        private final LinkedHashSet<IConverter> converters = new LinkedHashSet();
        private ISelectionStrategy selectionStrategy = new RoundRobinSelectionStrategy();
        private IConverterFailureCallback converterFailureCallback = new NoOpConverterFailureCallback();
        private boolean propagateShutDown = true;

        private Builder() {
        }

        public Builder aggregates(IConverter ... converters) {
            Preconditions.checkNotNull((Object)converters);
            return this.aggregates(Arrays.asList(converters));
        }

        public Builder aggregates(Collection<? extends IConverter> converters) {
            Preconditions.checkNotNull(converters);
            this.converters.addAll(converters);
            return this;
        }

        public Builder callback(IConverterFailureCallback converterFailureCallback) {
            Preconditions.checkNotNull((Object)converterFailureCallback);
            this.converterFailureCallback = converterFailureCallback;
            return this;
        }

        public Builder selectionStrategy(ISelectionStrategy selectionStrategy) {
            Preconditions.checkNotNull((Object)selectionStrategy);
            this.selectionStrategy = selectionStrategy;
            return this;
        }

        public Builder propagateShutDown(boolean propagateShutDown) {
            this.propagateShutDown = propagateShutDown;
            return this;
        }

        public IAggregatingConverter build() {
            return new AggregatingConverter(new CopyOnWriteArrayList<IConverter>(this.converters), this.selectionStrategy, this.converterFailureCallback, this.propagateShutDown);
        }

        public IAggregatingConverter build(ScheduledExecutorService executorService, long delay, TimeUnit timeUnit) {
            AggregatingConverter converter = new AggregatingConverter(new CopyOnWriteArrayList<IConverter>(this.converters), this.selectionStrategy, this.converterFailureCallback, this.propagateShutDown);
            converter.selfCheck = executorService.schedule(converter, delay, timeUnit);
            return converter;
        }
    }
}

