/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConversionJobWithSourceSpecified;
import com.documents4j.api.IConversionJobWithSourceUnspecified;
import com.documents4j.api.IConversionJobWithTargetUnspecified;
import com.documents4j.api.IConverter;
import com.documents4j.api.IConverterFailureCallback;
import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IFileSource;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.job.NoopFileConsumer;
import com.documents4j.job.OutputStreamToInputStreamConsumer;
import com.documents4j.throwables.ConverterAccessException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;

class FailureAwareConverter
implements IConverter {
    private final IConverter converter;
    private final IConverterFailureCallback failureCallback;

    FailureAwareConverter(IConverter converter, IConverterFailureCallback failureCallback) {
        this.converter = converter;
        this.failureCallback = failureCallback;
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source) {
        return new FailureAwareConversionWithSourceUnspecified(this.converter.convert(source));
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source, boolean close) {
        return new FailureAwareConversionWithSourceUnspecified(this.converter.convert(source, close));
    }

    public IConversionJobWithSourceUnspecified convert(IInputStreamSource source) {
        return new FailureAwareConversionWithSourceUnspecified(this.converter.convert(source));
    }

    public IConversionJobWithSourceUnspecified convert(File source) {
        return new FailureAwareConversionWithSourceUnspecified(this.converter.convert(source));
    }

    public IConversionJobWithSourceUnspecified convert(IFileSource source) {
        return new FailureAwareConversionWithSourceUnspecified(this.converter.convert(source));
    }

    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        return this.converter.getSupportedConversions();
    }

    public boolean isOperational() {
        return this.converter.isOperational();
    }

    public void shutDown() {
        this.converter.shutDown();
    }

    public void kill() {
        this.converter.kill();
    }

    private void reportException(Exception e) {
        if (e instanceof ConverterAccessException) {
            this.failureCallback.onFailure(this.converter);
        }
    }

    private class FailureAwareStreamConsumer
    implements IInputStreamConsumer {
        private final IInputStreamConsumer inputStreamConsumer;

        private FailureAwareStreamConsumer(IInputStreamConsumer inputStreamConsumer) {
            this.inputStreamConsumer = inputStreamConsumer;
        }

        public void onComplete(InputStream inputStream) {
            this.inputStreamConsumer.onComplete(inputStream);
        }

        public void onCancel() {
            this.inputStreamConsumer.onCancel();
        }

        public void onException(Exception e) {
            try {
                FailureAwareConverter.this.reportException(e);
            }
            finally {
                this.inputStreamConsumer.onException(e);
            }
        }
    }

    private class FailureAwareFileConsumer
    implements IFileConsumer {
        private final IFileConsumer fileConsumer;

        private FailureAwareFileConsumer(IFileConsumer fileConsumer) {
            this.fileConsumer = fileConsumer;
        }

        public void onComplete(File file) {
            this.fileConsumer.onComplete(file);
        }

        public void onCancel(File file) {
            this.fileConsumer.onCancel(file);
        }

        public void onException(File file, Exception e) {
            try {
                FailureAwareConverter.this.reportException(e);
            }
            finally {
                this.fileConsumer.onException(file, e);
            }
        }
    }

    private class FailureAwareConversionWithSourceSpecified
    implements IConversionJobWithSourceSpecified {
        private final IConversionJobWithSourceSpecified conversionJob;

        private FailureAwareConversionWithSourceSpecified(IConversionJobWithSourceSpecified conversionJob) {
            this.conversionJob = conversionJob;
        }

        public IConversionJobWithTargetUnspecified to(File target) {
            return this.to(target, (IFileConsumer)new NoopFileConsumer());
        }

        public IConversionJobWithTargetUnspecified to(File target, IFileConsumer callback) {
            return this.conversionJob.to(target, (IFileConsumer)new FailureAwareFileConsumer(callback));
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target) {
            return this.to(target, true);
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target, boolean closeStream) {
            return this.to((IInputStreamConsumer)new OutputStreamToInputStreamConsumer(target, closeStream));
        }

        public IConversionJobWithTargetUnspecified to(IInputStreamConsumer callback) {
            return this.conversionJob.to((IInputStreamConsumer)new FailureAwareStreamConsumer(callback));
        }
    }

    private class FailureAwareConversionWithSourceUnspecified
    implements IConversionJobWithSourceUnspecified {
        private final IConversionJobWithSourceUnspecified conversionJob;

        private FailureAwareConversionWithSourceUnspecified(IConversionJobWithSourceUnspecified conversionJob) {
            this.conversionJob = conversionJob;
        }

        public IConversionJobWithSourceSpecified as(DocumentType sourceFormat) {
            return new FailureAwareConversionWithSourceSpecified(this.conversionJob.as(sourceFormat));
        }
    }
}

