/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConversionJob;
import com.documents4j.api.IConversionJobWithPriorityUnspecified;
import com.documents4j.api.IConversionJobWithSourceSpecified;
import com.documents4j.api.IConversionJobWithSourceUnspecified;
import com.documents4j.api.IConversionJobWithTargetUnspecified;
import com.documents4j.api.IConverter;
import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IFileSource;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.throwables.ConversionFormatException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class ImpossibleConverter
implements IConverter {
    private static final String MESSAGE = "There is currently no converter accessible";

    ImpossibleConverter() {
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source) {
        return new ImpossibleConversionJobWithSourceUnspecified();
    }

    public IConversionJobWithSourceUnspecified convert(InputStream source, boolean close) {
        return new ImpossibleConversionJobWithSourceUnspecified();
    }

    public IConversionJobWithSourceUnspecified convert(IInputStreamSource source) {
        return new ImpossibleConversionJobWithSourceUnspecified();
    }

    public IConversionJobWithSourceUnspecified convert(File source) {
        return new ImpossibleConversionJobWithSourceUnspecified();
    }

    public IConversionJobWithSourceUnspecified convert(IFileSource source) {
        return new ImpossibleConversionJobWithSourceUnspecified();
    }

    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        return Collections.emptyMap();
    }

    public boolean isOperational() {
        return false;
    }

    public void shutDown() {
    }

    public void kill() {
    }

    private static class NoOpExceptionCallback
    implements ExceptionCallback {
        private NoOpExceptionCallback() {
        }

        @Override
        public void onException(ConversionFormatException exception) {
        }
    }

    private static class InputStreamConsumerExceptionCallback
    implements ExceptionCallback {
        private final IInputStreamConsumer callback;

        public InputStreamConsumerExceptionCallback(IInputStreamConsumer callback) {
            this.callback = callback;
        }

        @Override
        public void onException(ConversionFormatException exception) {
            this.callback.onException((Exception)exception);
        }
    }

    private static class FileConsumerExceptionCallback
    implements ExceptionCallback {
        private final File target;
        private final IFileConsumer callback;

        public FileConsumerExceptionCallback(File target, IFileConsumer callback) {
            this.target = target;
            this.callback = callback;
        }

        @Override
        public void onException(ConversionFormatException exception) {
            this.callback.onException(this.target, (Exception)exception);
        }
    }

    private static interface ExceptionCallback {
        public void onException(ConversionFormatException var1);
    }

    private static class ImpossibleConversionFuture
    implements Future<Boolean> {
        private final ConversionFormatException exception;

        public ImpossibleConversionFuture(ConversionFormatException exception) {
            this.exception = exception;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Boolean get() throws ExecutionException {
            throw new ExecutionException((Throwable)this.exception);
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws ExecutionException {
            return this.get();
        }
    }

    private static class ImpossibleConversionJobWithPriorityUnspecified
    implements IConversionJobWithPriorityUnspecified {
        private final ExceptionCallback exceptionCallback;

        private ImpossibleConversionJobWithPriorityUnspecified(ExceptionCallback exceptionCallback) {
            this.exceptionCallback = exceptionCallback;
        }

        public IConversionJob prioritizeWith(int priority) {
            return this;
        }

        public ImpossibleConversionFuture schedule() {
            ConversionFormatException exception = new ConversionFormatException(ImpossibleConverter.MESSAGE);
            this.exceptionCallback.onException(exception);
            return new ImpossibleConversionFuture(exception);
        }

        public boolean execute() {
            ConversionFormatException exception = new ConversionFormatException(ImpossibleConverter.MESSAGE);
            this.exceptionCallback.onException(exception);
            throw exception;
        }
    }

    private static class ImpossibleConversionJobWithTargetUnspecified
    implements IConversionJobWithTargetUnspecified {
        private final ExceptionCallback exceptionCallback;

        public ImpossibleConversionJobWithTargetUnspecified(ExceptionCallback exceptionCallback) {
            this.exceptionCallback = exceptionCallback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return new ImpossibleConversionJobWithPriorityUnspecified(this.exceptionCallback);
        }
    }

    private static class ImpossibleConversionJobWithSourceSpecified
    implements IConversionJobWithSourceSpecified {
        private ImpossibleConversionJobWithSourceSpecified() {
        }

        public IConversionJobWithTargetUnspecified to(File target) {
            return new ImpossibleConversionJobWithTargetUnspecified(new NoOpExceptionCallback());
        }

        public IConversionJobWithTargetUnspecified to(File target, IFileConsumer callback) {
            return new ImpossibleConversionJobWithTargetUnspecified(new FileConsumerExceptionCallback(target, callback));
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target) {
            return new ImpossibleConversionJobWithTargetUnspecified(new NoOpExceptionCallback());
        }

        public IConversionJobWithTargetUnspecified to(OutputStream target, boolean closeStream) {
            return new ImpossibleConversionJobWithTargetUnspecified(new NoOpExceptionCallback());
        }

        public IConversionJobWithTargetUnspecified to(IInputStreamConsumer callback) {
            return new ImpossibleConversionJobWithTargetUnspecified(new InputStreamConsumerExceptionCallback(callback));
        }
    }

    private static class ImpossibleConversionJobWithSourceUnspecified
    implements IConversionJobWithSourceUnspecified {
        private ImpossibleConversionJobWithSourceUnspecified() {
        }

        public IConversionJobWithSourceSpecified as(DocumentType sourceFormat) {
            return new ImpossibleConversionJobWithSourceSpecified();
        }
    }
}

