/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IConverter;
import com.documents4j.api.ISelectionStrategy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class RoundRobinSelectionStrategy
implements ISelectionStrategy {
    private final AtomicInteger atomicInteger = new AtomicInteger(0);

    RoundRobinSelectionStrategy() {
    }

    @Override
    public IConverter select(List<IConverter> converters) {
        return converters.get(this.nextIndex() % converters.size());
    }

    private int nextIndex() {
        int next;
        int current;
        while (!this.atomicInteger.compareAndSet(current = this.atomicInteger.get(), next = current + 1)) {
        }
        return current;
    }
}

