/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion;

import com.documents4j.conversion.IExternalConverter;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

enum ExternalConverterDiscovery {
    MICROSOFT_WORD("com.documents4j.conversion.msoffice.MicrosoftWordBridge"),
    MICROSOFT_EXCEL("com.documents4j.conversion.msoffice.MicrosoftExcelBridge");

    private final String className;

    private ExternalConverterDiscovery(String className) {
        this.className = className;
    }

    private static IExternalConverter make(Class<? extends IExternalConverter> externalConverterClass, File baseFolder, long processTimeout, TimeUnit timeUnit) {
        try {
            return externalConverterClass.getConstructor(File.class, Long.TYPE, TimeUnit.class).newInstance(new Object[]{baseFolder, processTimeout, timeUnit});
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("%s could not be created by a (File, long, TimeUnit) constructor", externalConverterClass), e);
        }
    }

    private static Set<IExternalConverter> makeAll(Set<Class<? extends IExternalConverter>> externalConverterClasses, File baseFolder, long processTimeout, TimeUnit timeUnit) {
        HashSet<IExternalConverter> externalConverters = new HashSet<IExternalConverter>();
        for (Class<? extends IExternalConverter> externalConverterClass : externalConverterClasses) {
            externalConverters.add(ExternalConverterDiscovery.make(externalConverterClass, baseFolder, processTimeout, timeUnit));
        }
        return externalConverters;
    }

    private static Set<Class<? extends IExternalConverter>> discover(Map<Class<? extends IExternalConverter>, Boolean> externalConverterRegistration) {
        HashSet<Class<? extends IExternalConverter>> discovered = new HashSet<Class<? extends IExternalConverter>>();
        Map<String, ExternalConverterDiscovery> autoDetectNameMap = ExternalConverterDiscovery.makeAutoDetectNameMap();
        for (Map.Entry<Class<? extends IExternalConverter>, Boolean> registration : externalConverterRegistration.entrySet()) {
            if (registration.getValue().booleanValue()) {
                discovered.add(registration.getKey());
                continue;
            }
            autoDetectNameMap.remove(registration.getKey().getName());
        }
        for (ExternalConverterDiscovery autoDetect : autoDetectNameMap.values()) {
            Class<? extends IExternalConverter> externalConverterClass = autoDetect.tryFindClass();
            if (externalConverterClass == null) continue;
            discovered.add(externalConverterClass);
        }
        return discovered;
    }

    private static Set<Class<? extends IExternalConverter>> validate(Set<Class<? extends IExternalConverter>> externalConverterClasses) {
        if (externalConverterClasses.size() == 0) {
            throw new IllegalStateException("The application was started without any registered or class-path discovered converters.");
        }
        return externalConverterClasses;
    }

    private static Map<String, ExternalConverterDiscovery> makeAutoDetectNameMap() {
        HashMap<String, ExternalConverterDiscovery> autoDetectNames = new HashMap<String, ExternalConverterDiscovery>();
        for (ExternalConverterDiscovery autoDetect : ExternalConverterDiscovery.values()) {
            autoDetectNames.put(autoDetect.getClassName(), autoDetect);
        }
        return autoDetectNames;
    }

    public static Set<IExternalConverter> loadConfiguration(File baseFolder, long processTimeout, TimeUnit timeUnit, Map<Class<? extends IExternalConverter>, Boolean> externalConverterRegistration) {
        return ExternalConverterDiscovery.makeAll(ExternalConverterDiscovery.validate(ExternalConverterDiscovery.discover(externalConverterRegistration)), baseFolder, processTimeout, timeUnit);
    }

    protected String getClassName() {
        return this.className;
    }

    protected Class<? extends IExternalConverter> tryFindClass() {
        try {
            Class<?> foundClass = Class.forName(this.getClassName(), false, ((Object)((Object)this)).getClass().getClassLoader());
            Preconditions.checkState((boolean)IExternalConverter.class.isAssignableFrom(foundClass), (Object)"Illegal auto discovery class implementation found");
            return foundClass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

