/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.client.TypeRef;
import com.docusign.esign.model.TabMetadata;
import com.docusign.esign.model.TabMetadataList;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomTabsApi {
    private ApiClient apiClient;

    public CustomTabsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomTabsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TabMetadataList list(String accountId) throws ApiException {
        return this.list(accountId, null);
    }

    public TabMetadataList list(String accountId, ListOptions options) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling list");
        }
        String path = "/v2/accounts/{accountId}/tab_definitions".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "custom_tab_only", options.customTabOnly));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<TabMetadataList> returnType = new TypeRef<TabMetadataList>(){};
        return (TabMetadataList)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public TabMetadata create(String accountId, TabMetadata tabMetadata) throws ApiException {
        TabMetadata postBody = tabMetadata;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling create");
        }
        String path = "/v2/accounts/{accountId}/tab_definitions".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<TabMetadata> returnType = new TypeRef<TabMetadata>(){};
        return (TabMetadata)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public TabMetadata get(String accountId, String customTabId) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling get");
        }
        if (customTabId == null) {
            throw new ApiException(400, "Missing the required parameter 'customTabId' when calling get");
        }
        String path = "/v2/accounts/{accountId}/tab_definitions/{customTabId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{customTabId\\}", this.apiClient.escapeString(customTabId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<TabMetadata> returnType = new TypeRef<TabMetadata>(){};
        return (TabMetadata)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public TabMetadata update(String accountId, String customTabId, TabMetadata tabMetadata) throws ApiException {
        TabMetadata postBody = tabMetadata;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (customTabId == null) {
            throw new ApiException(400, "Missing the required parameter 'customTabId' when calling update");
        }
        String path = "/v2/accounts/{accountId}/tab_definitions/{customTabId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{customTabId\\}", this.apiClient.escapeString(customTabId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<TabMetadata> returnType = new TypeRef<TabMetadata>(){};
        return (TabMetadata)this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void delete(String accountId, String customTabId) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling delete");
        }
        if (customTabId == null) {
            throw new ApiException(400, "Missing the required parameter 'customTabId' when calling delete");
        }
        String path = "/v2/accounts/{accountId}/tab_definitions/{customTabId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{customTabId\\}", this.apiClient.escapeString(customTabId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public class ListOptions {
        private String customTabOnly = null;

        public void setCustomTabOnly(String customTabOnly) {
            this.customTabOnly = customTabOnly;
        }

        public String getCustomTabOnly() {
            return this.customTabOnly;
        }
    }
}

