/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.client.TypeRef;
import com.docusign.esign.model.ApiRequestLogsResult;
import com.docusign.esign.model.DiagnosticsSettingsInformation;
import com.docusign.esign.model.ResourceInformation;
import com.docusign.esign.model.ServiceInformation;
import java.util.ArrayList;
import java.util.HashMap;

public class DiagnosticsApi {
    private ApiClient apiClient;

    public DiagnosticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DiagnosticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ServiceInformation getService() throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        String path = "/service_information".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<ServiceInformation> returnType = new TypeRef<ServiceInformation>(){};
        return (ServiceInformation)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ResourceInformation getResources() throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        String path = "/v2".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<ResourceInformation> returnType = new TypeRef<ResourceInformation>(){};
        return (ResourceInformation)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public ApiRequestLogsResult listRequestLogs() throws ApiException {
        return this.listRequestLogs(null);
    }

    public ApiRequestLogsResult listRequestLogs(ListRequestLogsOptions options) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        String path = "/v2/diagnostics/request_logs".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "encoding", options.encoding));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<ApiRequestLogsResult> returnType = new TypeRef<ApiRequestLogsResult>(){};
        return (ApiRequestLogsResult)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deleteRequestLogs() throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        String path = "/v2/diagnostics/request_logs".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public byte[] getRequestLog(String requestLogId) throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        if (requestLogId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestLogId' when calling getRequestLog");
        }
        String path = "/v2/diagnostics/request_logs/{requestLogId}".replaceAll("\\{format\\}", "json").replaceAll("\\{requestLogId\\}", this.apiClient.escapeString(requestLogId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"text/plain"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        byte[] fileBytes = this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames);
        return fileBytes;
    }

    public DiagnosticsSettingsInformation getRequestLogSettings() throws ApiException {
        Object postBody = null;
        byte[] postBinaryBody = null;
        String path = "/v2/diagnostics/settings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<DiagnosticsSettingsInformation> returnType = new TypeRef<DiagnosticsSettingsInformation>(){};
        return (DiagnosticsSettingsInformation)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public DiagnosticsSettingsInformation updateRequestLogSettings(DiagnosticsSettingsInformation diagnosticsSettingsInformation) throws ApiException {
        DiagnosticsSettingsInformation postBody = diagnosticsSettingsInformation;
        byte[] postBinaryBody = null;
        String path = "/v2/diagnostics/settings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        TypeRef<DiagnosticsSettingsInformation> returnType = new TypeRef<DiagnosticsSettingsInformation>(){};
        return (DiagnosticsSettingsInformation)this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, postBinaryBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class ListRequestLogsOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

